﻿using jiouosdp.Models;
using RFrameGenerate.BLL.Marketing;
using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace jiouosdp.Areas.Marketing.Models
{
    public class ActivityCoupons : BasePageModel
    {
        #region 属性与构造函数

        public Guid ActiviyGuid { get; set; }

        public ActivityCoupons()
        {
        }
        public ActivityCoupons(Guid activityGuid)
        {
            this.ActiviyGuid = activityGuid;
        }
        
        #endregion

        private T_SA_StoreActivity _activity = null;
        public T_SA_StoreActivity Activity
        {
            get
            {
                if (_activity != null) return _activity;

                if (this.ActiviyGuid == Guid.Empty) _activity = new T_SA_StoreActivity();

                if (_activity != null) return _activity;

                _activity = StoreActivityManage.GetActivity(this.ActiviyGuid);

                if (_activity != null) return _activity;

                _activity = new T_SA_StoreActivity();

                return _activity;
            }
            set
            {
                if (value == null) return;

                _activity = value;
            }
        }

        private T_SA_StoreCoupons _coupons = null;
        public T_SA_StoreCoupons Coupons
        {
            get
            {
                if (_coupons != null) return _coupons;

                if (this.Activity == null || this.Activity.StoreActivityGuid == Guid.Empty) _coupons = new T_SA_StoreCoupons();

                if (_coupons != null) return _coupons;

                _coupons = StoreCouponsManage.GetCouponsByActivity(this.Activity.StoreActivityGuid);

                if (_coupons != null) return _coupons;

                _coupons = new T_SA_StoreCoupons();

                return _coupons;
            }
        }
    }
}