﻿using RFrameGenerate.BLL;
using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace jiouosdp.Areas.Merchant.Controllers
{
    public class MerchantController : Controller
    {
        public ActionResult LowerAgentList()
        {
            return View();
        }

        public ActionResult AgentGroupList()
        {
            ViewBag.FlagShipGroup = MerchantManage.GetFlagShipGroupList();
            return View();
        }

        public JsonResult GetPageList(GridModel gridModel, string groupName)
        {
            groupName = (groupName == null ? "" : groupName);
            var list = MerchantManage.GetPageList(gridModel, groupName);
            gridModel.datarows = (from s in list
                                  select new
                                  {
                                      id = s.FlagshipGroupGuid,
                                      cell = new object[]
                                            {
                                                s.AgentsFlagshipGuid,
                                                s.GroupName,
                                                s.MerchantNum,
                                                s.Sort
                                            }
                                  }).ToArray();
            return Json(gridModel.PackagePageModel());
        }

        public JsonResult Del_FlagShip(Guid? entityGuid)
        {
            var result = MerchantManage.DeleteEntity(entityGuid.Value);

            if (result.State == true)
                return Json(new { Result = "OK" });
            else
                return Json(new { Result = "NO", Msg = result.Msg });
        }

        //public JsonResult Save_FlagShip(T_BAS_FlagshipGroup entity)
        //{
        //    var result = MerchantManage.SaveChangeEntity(entity);
        //    if (result.State == true)
        //        return Json(new { Result = "OK" });
        //    else
        //        return Json(new { Result = "NO", Msg = result.Msg });
        //}

        //public JsonResult Save_FlagShipGroup(T_BAS_Merchants entity)
        //{
        //    var result = MerchantManage.SaveFlagShipGroup(entity);
        //    if (result.State == true)
        //        return Json(new { Result = "OK" });
        //    else
        //        return Json(new { Result = "NO", Msg = result.Msg });
        //}

        //public JsonResult GetMerchantPageListGroup(GridModel gridModel, string searchType, string searchText)
        //{
        //    var list = MerchantManage.GetMerchantPageListGroup(gridModel, searchType, searchText);
        //    gridModel.datarows = (from s in list
        //                          select new
        //                          {
        //                              id = s.MerchantGuid,
        //                              cell = new object[]
        //                                    {
        //                                        s.UserID,
        //                                        s.StoreTitle,
        //                                        s.EMail,
        //                                        s.Contact,
        //                                        s.Telephone,
        //                                        s.Address,
        //                                        MerchantManage.ProductPutAway("上架",s.MerchantGuid),
        //                                        MerchantManage.ProductPutAway("下架",s.MerchantGuid),
        //                                        MerchantManage.GetUpperAgent(s.MerchantGuid),
        //                                        MerchantManage.GetTotalAgent(s.MerchantGuid),
        //                                        s.CreateDate.ToString("yyyy-MM-dd"),
        //                                        s.StoreState==true?"正常":"禁用"
        //                                    }
        //                          }).ToArray();
        //    return Json(gridModel.PackagePageModel());
        //}

        public JsonResult Forbidden_FlagShip(Guid? entityGuid, string stateShow)
        {
            var result = MerchantManage.ForbiddenFlagShip(entityGuid.Value, stateShow);

            if (result.State == true)
                return Json(new { Result = "OK" });
            else
                return Json(new { Result = "NO", Msg = result.Msg });
        }

        public JsonResult MerchantUpdatePwd(Guid? entityGuid, string newPassword)
        {
            var result = MerchantManage.MerchantUpdatePwd(entityGuid.Value, newPassword);

            if (result.State == true)
                return Json(new { Result = "OK" });
            else
                return Json(new { Result = "NO", Msg = result.Msg });
        } 
    }
}
