﻿using RFrameGenerate.BLL;
using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace jiouosdp.Areas.MessageTemplate.Controllers
{
    public class MainController : Controller
    {
        //
        // GET: /MessageTemplate/Main/

        [PF(PCode.WeiXinManage.MessageTemplate)]
        public ActionResult Index()
        {
            return View();
        }
        /// <summary>
        /// 加载商品分类
        /// </summary>
        /// <param name="gridModel"></param>
        /// <returns></returns>
        public ActionResult LoadData(GridModel gridModel)
        {
            var list = MessageTemplateManage.LoadData(gridModel);
            gridModel.datarows = (from s in list
                                  select new
                                  {
                                      id = s.MessageTemplateGuid,
                                      cell = new object[]
                                            {
                                                s.MessageTemplateGuid,
                                                s.MerchantGuid,
                                                s.TemplateType.Value,
                                                TemplateType.GetTypeName((s.TemplateType.Value)),
                                                s.TemplateID,
                                                s.MessageType,
                                                s.Received,
                                                s.Content,
                                                s.TemplateNo,                                       
                                            }
                                  }).ToArray();
            return Json(gridModel.PackagePageModel());
        }

        public JsonResult LoadTemplateType()
        {
            List<TemplateType> relList = new List<TemplateType>();
            var result = MessageTemplateManage.GetList(ref relList);
            return Json(new { Result = "OK", List = relList });
        }

        public JsonResult DelTemplate(Guid entityGuid)
        {
            var result = MessageTemplateManage.DelTemplate(entityGuid);
            if (result.State)
                return Json(new { Result = "OK" });
            else
                return Json(new { Result = "NO", Msg = result.Msg });
        }

        public JsonResult SaveTemplate(T_BAS_MessageTemplate entity)
        {
            var result = MessageTemplateManage.SaveTemplate(entity);
            if (result.State)
                return Json(new { Result = "OK" });
            else
                return Json(new { Result = "NO", Msg = result.Msg });
        }

        public JsonResult GetTemplate(int typeID)
        {
            T_BAS_MessageTemplate model = new T_BAS_MessageTemplate();
            var result = MessageTemplateManage.GetTemplate(typeID, ref model);
            if (result.State)
                return Json(new { Result = "OK", Model = model });
            else
                return Json(new { Result = "NO", Msg = result.Msg });
        }
    }
}
