﻿using RFrameGenerate.BLL;
using RFrameGenerate.BLL.Products;
using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace jiouosdp.Areas.ProductCrowd.Controllers
{
    [MerchantFilter()]
    public class ProductController : Controller
    {
        //
        // GET: /ProductCrowd/Product/

        [PF(PCode.MarketingManage.CrowdfundingManage.ProductCrowdProduct)]
        public ActionResult Index()
        {
            return View();
        }

        public ActionResult LoadData(GridModel gridModel)
        {
            var list = ProductCrowdManage.GetProductCrowdPage(gridModel);
            gridModel.datarows = (from s in list
                                  select new
                                  {
                                      id = s.ProductCrowdGuid,
                                      cell = new object[]
                                            {
                                                s.ProductName,
                                                s.UnitPrice,
                                                s.Price,
                                                s.IsAutoEnable,
                                                s.MaxPeriod,
                                                s.JoinDate.ToString("yyyy/MM/dd HH:mm:ss"),    
                                                s.BuyUnitPrice,
                                                s.Sort,
                                            }
                                  }).ToArray();
            return Json(gridModel.PackagePageModel());
        }


        public ActionResult LoadDetailData(GridModel gridModel, Guid? id)
        {
            var list = ProductCrowdManage.GetProductCrowdPeriodPage(gridModel, id);
            gridModel.datarows = (from s in list
                                  select new
                                  {
                                      id = s.ProductCrowdPeriodGuid,
                                      cell = new object[]
                                            {
                                                s.CrowdPeriods,
                                                s.TotalTime,
                                                s.BuyTime,
                                                s.RemainTime,             
                                                s.JoinDate.ToString("yyyy/MM/dd HH:mm:ss"),   
                                                s.OpenDate==null?"未开奖": s.OpenDate.ToString("yyyy/MM/dd HH:mm:ss"), 
                                                s.LuckyNum,   
                                                s.MemberNickName,   
                                                s.WinningBuyTime,  
                                                s.CrowdWinningGuid,
                                            }
                                  }).ToArray();
            return Json(gridModel.PackagePageModel());
        }

        public ActionResult LoadProductListData(GridModel gridModel, string name)
        {
            var list = ProductCrowdManage.GetPageList(gridModel, name);
            gridModel.datarows = (from s in list
                                  select new
                                  {
                                      id = s.ProductGuid,
                                      cell = new object[]
                                            {
                                                s.ProductName,
                                                s.ProductCode
                                            }
                                  }).ToArray();
            return Json(gridModel.PackagePageModel());
        }


        public JsonResult Join(Guid id)
        {
            var result = ProductCrowdManage.Join(id);
            if (result.State == true)
                return Json(new { Result = "OK" });
            else
                return Json(new { Result = "NO", Msg = result.Msg });
        }

        public JsonResult EditEnable(Guid id, bool state)
        {
            var result = ProductCrowdManage.EditEnable(id, state);
            if (result.State == true)
            {
                return Json(new { Result = "OK" });
            }
            else
            {
                return Json(new { Result = "NO", Msg = result.Msg });
            }
        }
        public JsonResult Edit(T_CR_ProductCrowd data)
        {
            var result = ProductCrowdManage.Edit(data);
            if (result.State == true)
            {
                return Json(new { Result = "OK" });
            }
            else
            {
                return Json(new { Result = "NO", Msg = result.Msg });
            }
        }

        public JsonResult Del(Guid id)
        {
            var result = ProductCrowdManage.Del(id);
            if (result.State == true)
            {
                return Json(new { Result = "OK" });
            }
            else
            {
                return Json(new { Result = "NO", Msg = result.Msg });
            }
        }

        [PF(PCode.MarketingManage.CrowdfundingManage.ProductCrowdWinning)]
        public ActionResult Winning()
        {
            return View();
        }
        public ActionResult LoadWinningData(GridModel gridModel, int? state = -10)
        {
            var list = CrowdParticipateManage.GetCrowdParticipateAllPageList(gridModel, state); ;
            gridModel.datarows = (from s in list
                                  select new
                                  {
                                      id = s.CrowdParticipateGuid,
                                      cell = new object[]
                                            {       
                                                s.ProductName,
                                                s.CrowdPeriods,
                                                s.MemberNickName,
                                                s.Reciever,
                                                s.RecieverTelephone,
                                                string.Format("{0}{1}{2}{3}",s.Province,s.RecieverCity,s.RecieverArea,s.RecieverAddress),
                                                s.CrowdState,
                                                s.LuckyNum,
                                                string.Format("{0}/{1}",s.WinBuyTime,s.TotalTime),
                                                s.JoinDate.ToString("yyyy/MM/dd HH:mm:ss"),
                                                s.OpenDate.ToString("yyyy/MM/dd HH:mm:ss"),
                                                s.DeliveryTime.ToString("yyyy/MM/dd HH:mm:ss"),
                                                s.CrowdWinningGuid,
                                                s.CrowdParticipateGuid,
                                            }
                                  }).ToArray();
            return Json(gridModel.PackagePageModel());
        }

        public JsonResult Delivery(Guid id, string expressNumber, Guid lc, string company, Guid cpid)
        {
            var result = CrowdParticipateManage.Delivery(id, expressNumber, lc, company, cpid);
            if (result.State)
            {
                return Json(new { Result = "OK" });
            }
            return Json(new { Result = "NO", Msg = result.Msg });
        }

    }
}
