﻿using LitJson;
using RFrameGenerate.BLL;
using RFrameGenerate.Common;
using RFrameGenerate.Model;
using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace jiouosdp.Areas.ProductCrowd.Controllers
{
    [MerchantFilter()]
    public class SlideController : Controller
    {
        [PF(PCode.MarketingManage.CrowdfundingManage.ProductCrowdSlide)]
        public ActionResult Index()
        {
            return View();
        }

        public JsonResult LoadSlideList(GridModel gridModel)
        {
            var list = ShopSlideManage.GetPageList(gridModel);
            Dictionary<Guid, T_BAS_Merchants> cache = new Dictionary<Guid, T_BAS_Merchants>();
            gridModel.datarows = (from s in list
                                  select new
                                  {
                                      id = s.ShopSlideGuid,
                                      cell = new object[]
                                            {
                                                s.MerchantGuid,
                                                GetMerchants(s.MerchantGuid,cache).StoreTitle,
                                                s.SlideImg,
                                                s.SlideUrl
                                            }
                                  }).ToArray();
            return Json(gridModel.PackagePageModel());
        }

        public JsonResult SaveOrUpdate(T_BAS_ShopSlide entity)
        {
            var result = ShopSlideManage.SaveOrUpdate(entity);

            if (!result.State) return Json(new { Result = "NO", Msg = result.Msg });

            return Json(new { Result = "OK" });
        }

        public JsonResult Delete(Guid shopSlideGuid)
        {
            var result = ShopSlideManage.Delete(shopSlideGuid);

            if (!result.State) return Json(new { Result = "NO", Msg = result.Msg });

            return Json(new { Result = "OK" });
        }

        [HttpPost]
        public void Upload()
        {
            string returnstr = string.Empty;
            string relativePath = string.Empty;
            try
            {
                foreach (string upload in Request.Files)
                {
                    var file = Request.Files[upload];
                    string fileNameExt = Path.GetExtension(file.FileName).ToLower();

                    if (fileNameExt != ".jpg" && fileNameExt != ".gif" && fileNameExt != ".png" && fileNameExt != ".jpeg" && fileNameExt != ".mp4")
                    {
                        throw new Exception("不合适的文件,只能支持jpg|gif|png的文件");
                    }

                    if (!UpLoadFileHelp.HasFile(file)) continue;

                    var dateTimeNow = DateTime.Now;
                    var basePath = string.Empty;

                    basePath = "/upload/shopslide";


                    var fileName = dateTimeNow.ToString("yyyyMMddHHmmss")
                        + RadomCode.DigitalCode(3) + fileNameExt;

                    relativePath = basePath + "/" + fileName;
                    string DirUrl = Server.MapPath("~" + basePath);

                    UpLoadFileHelp.SaveInFileSystem(file, DirUrl, fileName);
                }

                Hashtable successHash = new Hashtable();
                successHash["error"] = 0;
                successHash["url"] = relativePath;
                Response.AddHeader("Content-Type", "text/html; charset=UTF-8");
                Response.Write(JsonMapper.ToJson(successHash));
                Response.End();

            }
            catch (Exception e)
            {
                Hashtable failueHash = new Hashtable();
                failueHash["error"] = 1;
                failueHash["message"] = e.Message;
                Response.AddHeader("Content-Type", "text/html; charset=UTF-8");
                Response.Write(JsonMapper.ToJson(failueHash));
                Response.End();
            }

        }
        private T_BAS_Merchants GetMerchants(Guid? merchantsGuid, Dictionary<Guid, T_BAS_Merchants> cache)
        {
            if (merchantsGuid == null || merchantsGuid.Value == Guid.Empty) return new T_BAS_Merchants();

            if (cache.ContainsKey(merchantsGuid.Value)) return cache[merchantsGuid.Value];

            var merchants = MerchantManage.GetEntity(merchantsGuid.Value);

            if (merchants == null) merchants = new T_BAS_Merchants();

            cache.Add(merchantsGuid.Value, merchants);

            return merchants;
        }
    }
}