﻿using RFrameGenerate.BLL;
using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace jiouosdp.Areas.RefundApplys.Controllers
{
    public class MainController : Controller
    {
        //
        // GET: /RefundApplys/Main/

        [PF(PCode.TradeManage.RefundApplys)]
        public ActionResult Index()
        {
            return View();
        }

        #region   退款申请列表
        /// <summary>
        /// 获取退款申请列表（分页）
        /// </summary>
        /// <param name="gridModel"></param>
        /// <returns></returns>
        public JsonResult GetPageList(GridModel gridModel)
        {
            var list = RefundApplysManage.GetPageList(gridModel);
            gridModel.datarows = (from s in list
                                  select new
                                  {
                                      id = s.RefundApplyGuid,
                                      cell = new object[]
                                            {
                                                s.RefundApplyGuid,
                                                s.OrderGuid,
                                                s.MerchantGuid,
                                                s.OrderNo,
                                                s.Recipients,
                                                s.Telephone,
                                                s.RefundType,
                                                s.IsSignIn,
                                                s.IsRefund,
                                                s.RefundWay,
                                                s.RefundAmount,
                                                s.ApplyDateTime,
                                                s.RefundRemark,
                                                s.State,
                                                s.Account,
                                                s.Express,
                                                s.ExpressNo,
                                                s.SerialNumber,
                                                s.GoodsDeliveryType,
                                                s.CommodityRefundAudit
                                            }
                                  }).ToArray();
            return Json(gridModel.PackagePageModel());
        }

        /// <summary>
        /// 保存退款申请设置
        /// </summary>
        /// <param name="parameterList"></param>
        /// <returns></returns>
        public JsonResult Save_Parameters(List<T_SYS_Parameter> parameterList)
        {
            foreach(var p in parameterList)
            {
                if (p.ParameterName == "refundService_validity")
                {
                    var commissionSettlementTime = ParameterManage.GetParameterByName("commissionSettlementTime");
                    if (int.Parse(commissionSettlementTime) < int.Parse(p.ParameterValue))
                    {
                        return Json(new { Result = "NO", Msg = string.Format("佣金结算天数一定要大于退款申请有效天数,当前佣金结算天数为{0}", commissionSettlementTime) });
                    }
                    break;
                }
            }

            var result = ParameterManage.Save_Parameters(parameterList);
            if (result.State)
            {
                return Json(new { Result = "OK" });
            }
            return Json(new { Result = "NO", Msg = result.Msg });
        }

        /// <summary>
        /// 获取退款申请设置
        /// </summary>
        /// <param name="parameterList"></param>
        /// <returns></returns>
        public JsonResult GetParameters(Guid merchantGuid)
        {
            List<T_SYS_Parameter> relList = new List<T_SYS_Parameter>();
            var result = ParameterManage.GetParameters_RefundApplys(merchantGuid, ref  relList);
            if (result.State)
            {
                return Json(new { Result = "OK", ParametersList = relList });
            }
            return Json(new { Result = "NO", Msg = result.Msg });
        }
        /// <summary>
        /// 同意退款
        /// </summary>
        /// <param name="entityGuid"></param>
        /// <param name="shipAddressGuid"></param>
        /// <returns></returns>
        public JsonResult Action_Allow(Guid entityGuid, Guid? shipAddressGuid)
        {
            var result = RefundApplysManage.Action_Allow(entityGuid, shipAddressGuid);
            if (result.State)
            {
                return Json(new { Result = "OK" });
            }
            return Json(new { Result = "NO", Msg = result.Msg });
        }
        /// <summary>
        /// 拒绝退款
        /// </summary>
        /// <param name="entityGuid"></param>
        /// <param name="refundRemark"></param>
        /// <returns></returns>
        public JsonResult Action_Refuse(Guid entityGuid, string refundRemark)
        {
            var result = RefundApplysManage.Action_Refuse(entityGuid, refundRemark);
            if (result.State)
            {
                return Json(new { Result = "OK" });
            }
            return Json(new { Result = "NO", Msg = result.Msg });
        }
        /// <summary>
        /// 取消退款
        /// </summary>
        /// <param name="entityGuid"></param>
        /// <param name="reason"></param>
        /// <returns></returns>
        public JsonResult Action_Cancel(Guid entityGuid, string reason)
        {
            var result = RefundApplysManage.Action_Cancel(entityGuid, reason);
            if (result.State)
            {
                return Json(new { Result = "OK" });
            }
            return Json(new { Result = "NO", Msg = result.Msg });
        }
        /// <summary>
        /// 更新地址
        /// </summary>
        /// <param name="entityGuid"></param>
        /// <param name="refundAddress"></param>
        /// <returns></returns>
        public JsonResult Action_UpdateAddr(Guid entityGuid, Guid shipAddressGuid)
        {
            var result = RefundApplysManage.Action_UpdateAddr(entityGuid, shipAddressGuid);
            if (result.State)
            {
                return Json(new { Result = "OK" });
            }
            return Json(new { Result = "NO", Msg = result.Msg });
        }
        /// <summary>
        /// 确认退款[最终退款]
        /// </summary>
        /// <param name="entityGuid"></param>
        /// <returns></returns>
        public JsonResult Action_Confirm(Guid entityGuid)
        {
            var result = RefundApplysManage.RefundMoney(entityGuid);
            if (result.State)
            {
                return Json(new { Result = "OK" });
            }
            return Json(new { Result = "NO", Msg = result.Msg });
        }
        /// <summary>
        /// 获取退款信息
        /// </summary>
        /// <param name="entityGuid"></param>
        /// <returns></returns>
        public JsonResult Action_GetRefundInfo(Guid entityGuid)
        {
            T_BAS_RefundApplys model = new T_BAS_RefundApplys();
            var result = RefundApplysManage.Action_GetRefundInfo(entityGuid, ref model);
            if (result.State)
            {
                return Json(new { Result = "OK", Entity = model });
            }
            return Json(new { Result = "NO", Msg = result.Msg });
        }
        #endregion
    }
}
