﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.UI.WebControls;
using RFrameGenerate.BLL;
using RFrameGenerate.Model;

namespace jiouosdp.Areas.Systems.Controllers
{
    public class AddressController : Controller
    {
        //
        // GET: /System/Address/

        public ActionResult Index()
        {
            return View();
        }

        #region JsonResult GetShipAddressPageList
        /// <summary>
        /// get shipaddress page list 
        /// </summary>
        /// <param name="gridModel"></param>
        /// <param name="name"></param>
        /// <returns></returns>
        public JsonResult GetShipAddressPageList(GridModel gridModel, string name)
        {
            var slist = ShipAddressManage.GetShipAddressPageList(gridModel, name);
            gridModel.datarows = (slist.Select(c => new
            {
                id = c.ShipAddressGuid,
                cell = new object[]
                {
                    c.AddressName,
                    c.ContantName,
                    c.Country+c.Province+c.City+c.Area,
                    c.Address,
                    c.Zip,
                    c.Telephone,
                    c.Company,
                    c.Country,
                    c.Province,
                    c.City,
                    c.Area,
                    ""
                }
            }).ToArray());
            return Json(gridModel.PackagePageModel());
        } 
        #endregion

        #region JsonResult DeleteList
        /// <summary>
        /// delete address list
        /// </summary>
        /// <param name="shipAddressGuid"></param>
        /// <returns></returns>
        public JsonResult DeleteList(Guid shipAddressGuid)
        {
            var result = ShipAddressManage.RemoveAddress(shipAddressGuid);
            return result.State ? Json(new { Result = "OK" }) : Json(new { Result = "NO", Msg = result.Msg });
        } 
        #endregion

        #region JsonResult GetAreaData

        /// <summary>
        /// get area data
        /// </summary>
        /// <returns></returns>
        public JsonResult GetAreaData()
        {
            return Json(AreasManage.GetAreaData());
        }

        #endregion

        #region JsonResult AddList

        /// <summary>
        /// Add entity
        /// </summary>
        /// <param name="entity"></param>
        /// <returns></returns>
        public JsonResult AddList(T_BAS_ShipAddress entity)
        {
            var result = ShipAddressManage.AddAddress(entity);
            if (result.State)
            {
                return Json(new { Result = "OK", Data = entity });
            }
            return Json(new { Result = "NO", Msg = result.Msg });
        }

        #endregion

        #region JsonResult EditList

        /// <summary>
        /// edit entity
        /// </summary>
        /// <param name="entity"></param>
        /// <returns></returns>
        public JsonResult EditList(T_BAS_ShipAddress entity)
        {
            var result = ShipAddressManage.UpdateAddress(entity);
            if (result.State)
            {
                return Json(new { Result = "OK", Data = entity });
            }
            return Json(new { Result = "NO", Msg = result.Msg });
        }

        #endregion
    }                
}                    
