﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using LitJson;
using RFrameGenerate.BLL;
using RFrameGenerate.Common;
using RFrameGenerate.Model;

namespace jiouosdp.Areas.Systems.Controllers
{
    public class PayWaysController : Controller
    {
        //
        // GET: /Systems/PayWays/

        [PF(PCode.SystemStoreManage.PayWays)]
        public ActionResult Index()
        {
            return View();
        }

        public JsonResult LoadPayWayListdata(GridModel gridModel)
        {
            var list = PayWaysManage.GetMerchantByPayWayList();
            gridModel.datarows = (from s in list
                                  select new
                                  {
                                      id = s.PayWayGuid,//定义当前行数据的一个传输识别名称，一般以主键为名称，可以省略()
                                      cell = new object[]
                                                     {
                                                         s.Name,
                                                         s.Description,
                                                         s.IsEnable==true?1:s.IsEnable==null?-1:0,
                                                         HttpUtility.HtmlEncode( s.PayWayProp),
                                                        s.MerchantPayWayProp==null?string.Empty: HttpUtility.HtmlEncode( s.MerchantPayWayProp.Replace("\\","/")),
                                                      }
                                  }).ToArray();
            return Json(gridModel.PackagePageModel());
        }

        public JsonResult Save(Guid PayWayGuid, string jsondata, bool IsEnable)
        {
            var result = PayWaysManage.Save(PayWayGuid, jsondata, IsEnable);
            if (result.State == true)
            {
                return Json(new { Result = "OK" });
            }
            else
            {
                return Json(new { Result = "NO", Msg = result.Msg });
            }
        }



        [HttpPost]
        public void Upload(string id)
        {
            string returnstr = string.Empty;
            string relativePath = string.Empty;
            try
            {
                foreach (string upload in Request.Files)
                {
                    var file = Request.Files[upload];
                    if (file == null) continue;
                    var extension = Path.GetExtension(file.FileName);
                    if (extension == null) continue;
                    var fileNameExt = extension.ToLower();

                    if (fileNameExt != ".p12")
                    {
                        throw new Exception("不合适的文件,只能支持.p12格式证书");
                    }

                    if (!file.HasFile()) continue;

                    var dateTimeNow = DateTime.Now;
                    if (Request.UrlReferrer == null) continue;
                    var basePath = AppDomain.CurrentDomain.BaseDirectory + "upload\\cer";
                    var fileName = id + fileNameExt;
                    relativePath = basePath + "\\" + fileName;
                    file.SaveInFileSystem(basePath, fileName);
                }

                Hashtable successHash = new Hashtable();
                successHash["error"] = 0;
                successHash["url"] = relativePath;
                Response.AddHeader("Content-Type", "text/html; charset=UTF-8");
                Response.Write(JsonMapper.ToJson(successHash));
                Response.End();
            }
            catch (Exception e)
            {
                Hashtable failueHash = new Hashtable();
                failueHash["error"] = 1;
                failueHash["message"] = e.Message;
                Response.AddHeader("Content-Type", "text/html; charset=UTF-8");
                Response.Write(JsonMapper.ToJson(failueHash));
                Response.End();
            }

        }
    }
}
