﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using RFrameGenerate.BLL;
using RFrameGenerate.Model;
using jiouosdp.Controllers;

namespace jiouosdp.Areas.Systems.Controllers
{
    [MerchantFilter()]
    public class SysRolePermissionController : BaseController
    {
        public ActionResult Index()
        {
            return View();
        }
        #region 角色管理

        [PF(PCode.SystemManage.UserRole)]
        public ActionResult RoleManage()
        {
            return View();
        }
        public JsonResult GetPermission(Guid roleGuid)
        {
            RoleManage roleManage = new RoleManage();
            string treejson = roleManage.GetUserPermission(roleGuid);
            if (treejson == "[]")
                return Json(new { Result = "NO", Msg = "权限表没有数据!" });
            return Json(new { Result = "OK", Data = treejson });
        }
        public JsonResult UpdateRolePermission(Guid roleGuid, string[] checkedNodes)
        {
            RoleManage roleManage = new RoleManage();
            var result = roleManage.UpdateRolePermission(roleGuid, checkedNodes);
            if (result.State == true)
            {
                PermissionManage.ClearCachePermission();
                return Json(new { Result = "OK" });
            }
            return Json(new { Result = "Error", Msg = result.Msg });
        }
        //加载角色列表
        public JsonResult LoadRoleListdata(GridModel gridModel)
        {
            RoleManage roleManage = new RoleManage();
            gridModel.datarows = (from s in roleManage.GetRolePageList(gridModel)
                                  select new
                                  {
                                      id = s.RoleGuid,//定义当前行数据的一个传输识别名称，一般以主键为名称，可以省略()
                                      cell = new object[]
                                                     {
                                                         s.RoleCode,
                                                         s.RoleName,
                                                         s.RoleRemark
                                                      }
                                  }).ToArray();
            return Json(gridModel.PackagePageModel());
        }
        public JsonResult UpdateRole(T_ST_Role role)
        {
            RoleManage roleManage = new RoleManage();
            var result = roleManage.UpdateRole(role);
            if (result.State == true)
            {
                PermissionManage.ClearCachePermission();
                return Json(new { Result = "OK" });
            }
            else
                return Json(new { Result = "NO", Msg = result.Msg });
        }
        public JsonResult SaveRole(T_ST_Role role)
        {
            RoleManage roleManage = new RoleManage();
            var result = roleManage.SaveRole(role);
            if (result.State == true)
            {
                PermissionManage.ClearCachePermission();
                return Json(new { Result = "OK" });
            }
            else
                return Json(new { Result = "NO", Msg = result.Msg });
        }
        public JsonResult DeleteRole(Guid roleGuid)
        {
            RoleManage roleManage = new RoleManage();
            var result = roleManage.DeleteRole(roleGuid);
            if (result.State == true)
            {
                PermissionManage.ClearCachePermission();
                return Json(new { Result = "OK" });
            }
            else
                return Json(new { Result = "NO", Msg = result.Msg });
        }
        #endregion
    }
}
