﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using RFrameGenerate.BLL.Organization;
using RFrameGenerate.Model;
using jiouosdp.Controllers;
using RFrameGenerate.BLL;

namespace jiouosdp.Areas.Systems.Controllers
{
    [MerchantFilter()]
    public class SysUserRoleController : BaseController
    {
        public ActionResult Index()
        {
            return View();
        }

        #region 用户管理

        [PF(PCode.SystemManage.UserRole)]
        public ActionResult UserManage()
        {
            return View();
        }
        //加载用户列表
        public JsonResult LoadUserListdata(GridModel gridModel, string userName)
        {
            UserManage userManamge = new UserManage();
            var userList = userManamge.GetUserPageList(gridModel, userName);
            gridModel.datarows = (from s in userList
                                  select new
                                  {
                                      id = s.UserGuid,//定义当前行数据的一个传输识别名称，一般以主键为名称，可以省略()
                                      cell = new object[]
                                                     {
                                                         s.UserName,
                                                         s.LoginName,
                                                         s.Remark,
                                                         s.RoleName
                                                      }
                                  }).ToArray();
            return Json(gridModel.PackagePageModel());
        }
        public JsonResult SaveUser(T_ST_User user)
        {
            UserManage userManamge = new UserManage();
            Result result = userManamge.SaveUser(user);
            if (result.State == true)
                return Json(new { Result = "OK" });
            else
                return Json(new { Result = "NO", Msg = result.Msg });
        }
        public JsonResult AddUser(T_ST_User user)
        {
            UserManage userManamge = new UserManage();
            Result result = userManamge.AddUser(user);
            if (result.State == true)
                return Json(new { Result = "OK" });
            else
                return Json(new { Result = "NO", Msg = result.Msg });
        }
        public JsonResult GetRoleList(Guid userGuid)
        {
            UserManage userManamge = new UserManage();
            var result = userManamge.GetRoleList(userGuid);
            return Json(new { Result = "OK", Data = result });
        }
        public JsonResult UpdateUserRole(Guid userGuid, Guid[] checkedNodes)
        {
            UserManage userManamge = new UserManage();
            var result = userManamge.UpdateUserRole(userGuid, checkedNodes);
            if (result.State == true)
            {
                PermissionManage.ClearCachePermission();
                return Json(new { Result = "OK" });
            }
            return Json(new { Result = "Error", Msg = result.Msg });
        }
        #endregion
    }
}
