﻿using RFrameGenerate.BLL;
using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace jiouosdp.Areas.Systems.Controllers
{
    public class SystemToolsController : Controller
    {
        //
        // GET: /Systems/SystemTools/

        public ActionResult Index()
        {
            return View();
        }

        public JsonResult ImageCut()
        {
            var list = RFrameGenerate.BLL.Products.ProductsManage.GetListAll();
            Result result;
            
            try 
	        {	
                if (list == null || list.Count == 0) 
                {
                    result = new Result(false,"没有商品图片");
                    return Json(new { Result = "NO" });
                }
		        foreach (var item in list)
                { 
                    if (string.IsNullOrEmpty(item.ProductImage))
                    {
                        continue;
                    }

                    RFrameGenerate.Common.GraphicHelper.CutImage(Server.MapPath("~" + item.ProductImage), Server.MapPath("~" + DictionaryConst.UpLoadPath.ProductsImagePath));
                }
                return Json(new { Result = "OK" });
	        }
	        catch (Exception err)
	        {
		
		        return Json(new { Result = "NO",Msg=err.Message});
	        }
        }
    }
}
