﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using jiouosdp.Controllers;
using RFrameGenerate.Common;
using RFrameGenerate.BLL;

namespace jiouosdp.Areas.Theme.Controllers
{
    [LF(IsLoginFilter = false)]
    [PF(IsPermissionFilter = false)]
    public class MainController : BaseController
    {
        //
        // GET: /Theme/Main/
        [LF(IsLoginFilter = true)]
        public ActionResult Control()
        {
            if (CurrentManage.LoginType != DictionaryConst.LoginType.Merchant && CurrentManage.LoginType != DictionaryConst.LoginType.Employee)
            {
                RFrameGenerate.Common.CurrentUser.SetCurrUser(string.Empty, Guid.Empty);
                return Content("只能商家或员工才可以访问");
            }
            return View();
        }

        [LF(IsLoginFilter = true)]
        public ActionResult Agent()
        {
            if (CurrentManage.LoginType != DictionaryConst.LoginType.HeadOffice && CurrentManage.LoginType != DictionaryConst.LoginType.Agent)
            {
                RFrameGenerate.Common.CurrentUser.SetCurrUser(string.Empty, Guid.Empty);
                return Content("只能总代理或员代理商才可以访问");
            }
            return View();
        }


        public ActionResult Panel()
        {
            return View();
        }

        //tab
        public ActionResult tab()
        {
            return View();
        }

        public ActionResult Form()
        {
            return View();
        }

        public ActionResult Model()
        {
            return View();
        }

        public ActionResult MessageBox()
        {
            return View();
        }

        public ActionResult DateTime()
        {
            return View();
        }
    }
}
