﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using RFrameGenerate.BLL;
using RFrameGenerate.Model;
using RFramework.SQLServer;
using RFrameGenerate.Common;

namespace jiouosdp.Areas.Visitant.Controllers
{
    public class ListController : Controller
    {
        //
        // GET: /Visitant/List/

        [PF(PCode.MemberManage.MemberIndex)]
        public ActionResult Index()
        {
            return View();
        }

        #region JsonResult GetPageList
        /// <summary>
        /// get page list by member
        /// </summary>
        /// <param name="gridModel"></param>
        /// <param name="userName"></param>
        /// <returns></returns>
        public JsonResult GetPageList(GridModel gridModel, string userName, string _ID,string birthday)
        {
            var vipList = VisitantManager.GetVipList(gridModel, userName,_ID, birthday);
            gridModel.datarows = (vipList.Select(c => new
            {
                id = c.MemberGuid,
                cell = new object[]
                {
                    c.MemberID,
                    c.MemberNickName,
                    c.Country + c.Province + c.City,
                    c.Country + "-" + c.Province + "-" + c.City,
                    c.MemberName,
                    c.Birthday,
                    c.MemberMobilePhone,
                    c.Amount,
                    c.Balance,
                    c.AmountFrozen,
                    c.ExpenseTotal.ToString("0.00"),
                    c.IsDistributor==true?"是":"否",
                }
            })).ToArray();
            return Json(gridModel.PackagePageModel());
        }

        #endregion

        #region JsonResult GetDistributionPropPageList

        /// <summary>
        /// get distributionprop list
        /// </summary>
        /// <returns></returns>
        public JsonResult GetDistributionPropPageList(GridModel gridModel, string name)
        {
            var dlist = DistributionManage.GetDistributionPropPageList(gridModel, name);
            gridModel.datarows = dlist.Select(c => new
            {
                id = c.DistributionPropGuid,
                cell = new object[]
                {
                    c.DistributionName,
                    c.DistributionTelphone,
                    c.JoinDateTime.ToString("yyyy-MM-dd"),
                    c.SuperiorName,
                    c.DistributionAmount,
                    c.DistributionCommissions,
                    c.SubMemberNum,
                    c.WithdrawalAmount,
                    c.IsEnable == true ? "启用" : "关闭",
                    Convert.ToInt16(c.IsEnable),
                    "",
                    c.RQCode

                }
            }).ToArray();
            return Json(gridModel.PackagePageModel());
        }

        #endregion

        #region JsonResult GetAreaData

        /// <summary>
        /// get area data
        /// </summary>
        /// <returns></returns>
        public JsonResult GetAreaData()
        {
            return Json(AreasManage.GetAreaData());
        }

        #endregion

        #region JsonResult Delete
        /// <summary>
        /// delete function
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public JsonResult Delete(Guid id)
        {
            var result = VisitantManager.Delete(id);

            if (result.State)
            {
                return Json(new { Result = "OK" });
            }
            return Json(new { Result = "NO", Msg = result.Msg });
        }

        #endregion

        #region JsonResult Update

        /////// <summary>zhou 2015/10/27 del
        /////// Update function
        /////// </summary>
        /////// <param name="entity"></param>
        /////// <returns></returns>
        ////public JsonResult Update(T_BAS_Member entity)
        ////{
        ////    var result = VisitantManager.Update(entity);
        ////    if (result.State)
        ////    {
        ////        return Json(new { Result = "OK", Data = entity });
        ////    }
        ////    return Json(new { Result = "NO", Msg = result.Msg });
        ////}

        #endregion

        #region JsonResult BecomeReseller
        /// <summary>
        /// set is destribution
        /// </summary>
        /// <param name="memberGuid"></param>
        /// <returns></returns>
        public JsonResult BecomeReseller(Guid memberGuid, Guid prentid)
        {
            var mlist = MemberManage.GetMemberByGuid(memberGuid);
            if (mlist.IsDistributor == true)
            {
                return Json(new { Result = "NO", Msg = "设置失败，此用户已经是分销商。" });
            }
            using (SqlRTransaction tran = new SqlRTransaction())
            {
                Guid? parentMemberGuid = null;
                string ParentName = "总部";
                var dis = DistributionManage.GetDistributionPropToProp(prentid);
                if (dis != null)
                {
                    parentMemberGuid = dis.MemberGuid;
                    ParentName = dis.DistributionName;
                }

                tran.BeginTransaction();
                var entity = new T_BAS_ApplyDistributionRecords
                {
                    ApplyDateTime = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"),
                    ApplyDistributionRecordsGuid = Guid.NewGuid(),
                    DistributionName = mlist.MemberName,
                    MemberGuid = memberGuid,
                    SuperiorName = ParentName,
                    Telphone = mlist.MemberMobilePhone,
                    ParentMemberGuid = parentMemberGuid,

                };

                var result = ApplyDistributionRecordsManage.AddBecomeDistribution2(entity, RFrameGenerate.BLL.DictionaryConst.Apply.Pass);

                T_BAS_DistributionProp disEntity = new T_BAS_DistributionProp
                {
                    SubMemberNum = 0,
                    SuperiorName = ParentName,
                    IsEnable = true,
                    DistributionName = mlist.MemberName,
                    DistributionTelphone = mlist.MemberMobilePhone,
                    AmountFrozen = 0,
                    MemberGuid = memberGuid,
                    ParentDistributionPropGuid = prentid,
                };


                var guid = DistributionManage.AddApplyDistributionData(disEntity, memberGuid, entity.ApplyDateTime);

                DistributionManage.UpdataTeam(disEntity.DistributionPropGuid);

                string path = AppDomain.CurrentDomain.BaseDirectory + "upload/qrcode";
                var str = "http://" + MerchantManage.GetDomain() + "/WxShop/Index?did=" + guid;
                if (result.State)
                {
                    result = MemberManage.UpdataIsDis(memberGuid);
                }
                if (result.State)
                {
                    result = DistributionManage.GetQRcode(str, "", path, guid);
                }
                tran.Commit();
                return Json(result.State ? new { Result = "OK", Msg = result.Msg } : new { Result = "NO", Msg = result.Msg });
            }
        }
        #endregion

        public JsonResult GetDistributionPageList(GridModel gridModel, string userName)
        {
            var distProp = DistributionManage.GetEnalbeDistributionPropPageList(gridModel, userName);
            distProp.Insert(0, new T_BAS_DistributionProp() { DistributionPropGuid = Guid.Empty, DistributionName = "总部" });
            gridModel.datarows = (distProp.Select(c => new
            {
                id = c.DistributionPropGuid,
                cell = new object[]
                {
                    c.DistributionName,
                }
            })).ToArray();

            gridModel.recordCount++;

            return Json(gridModel.PackagePageModel());
        }

        public ActionResult Manage(string pwd)
        {
            if (pwd != "jioukeji804")
                return Content("密码错了");
            return View();
        }
        public JsonResult AnalogLogin(Guid id)
        {
            var member = MemberManage.GetMemberByGuid(id);
            var merch = MerchantManage.GetEntity(RFrameGenerate.Common.CurrentManage.MerchantGuid);
            if (member != null)
            {
                OpenIDManage.SetOpenID(member.MemberOpenID);
                return Json(new { Result = "OK", Url = string.Format("http://{0}/wxshop/index",merch.StoreUrl) });
            }
            else
            {
                return Json(new { Result="NO" });
            }
        }

        public JsonResult DelRel(Guid? id)
        {
            var result = MemberManage.DelRel(id.Value);
            if (result.State)
            {
                return Json(new { Result = "OK" });
            }
            return Json(new { Result = "NO", Msg = result.Msg });
        }
    }
}
