﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using RFrameGenerate.BLL;
using RFrameGenerate.BLL.WX_BaseCommon;
using jiouosdp.Controllers;

namespace jiouosdp.Areas.WeiXinApi.Controllers
{
    [PF(IsPermissionFilter = false)]
    [LF(IsLoginFilter = false, IsMaintenance = false)]
    public class MaterialController : BaseController
    {
        //
        //http://localhost:63587/WeiXinApi/Material/Show?code=1
        public ActionResult Show(string code )
        {
            try
            {
                var model = BaseCommonBLL.GetMaterialByCode(Convert.ToInt32(code));
                if (model.MaterialReplyType == BaseCommomDictionaryConst.MaterialReplyType.Text)
                {
                    return View(model);
                }
                else
                {
                    return Redirect(model.MaterialOutUrl);
                }
            }
            catch(Exception ex)
            {
                return Content(ex.Message);
            }
        }


    }
}
