﻿using jiouosdp.Controllers;
using RFrameGenerate.BLL;
using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace jiouosdp.Areas.WeiXinBase.Controllers
{
    public class MemberController : BaseController
    {
        //
        // GET: /Activitys/Member/

        public ActionResult Manage()
        {
            return View();
        }

        public ActionResult Edit(string guid)
        {
            try
            {
                var member = new T_BAS_Member();
                if (!string.IsNullOrEmpty(guid))
                {
                    //update
                    ViewBag.TabTitle = "编辑会员";
                    member = MemberManage.GetMemberByGuid(new Guid(guid));
                }
                else
                {
                    //add
                    ViewBag.TabTitle = "新增会员";
                }
                return View(member);
            }
            catch (Exception e)
            {
                ViewBag.Error = e.Message;
                return View();
            }
        }

        public JsonResult EditSubmit(T_BAS_Member member)
        {
            try
            {
                MemberManage.EditSubmit(member);
                return Json(new { Result = "OK" });
            }
            catch (Exception e)
            {
                return Json(new { Result = "Error", Data = e.Message });
            }
        }

        public JsonResult WeiXinSync()
        {
            try
            {
                MemberManage.WeiXinSync();
                return Json(new { Result = "OK" });
            }
            catch (Exception e)
            {
                return Json(new { Result = "Error", Data = e.Message });
            }
        }
        public JsonResult LoadData(GridModel gridModel, DateTime? dtFrom, DateTime? dtEnd, string MobilePhone, string MemberNickName)
        {
            //'会员昵称', '手机号码', '地址', '状态', '关注时间', '操作'
            gridModel.datarows = (from s in MemberManage.GetMemberPageList(gridModel, dtFrom, dtEnd, MobilePhone, MemberNickName)
                                  select new
                                  {
                                      id = s.MemberGuid,//定义当前行数据的一个传输识别名称，一般以主键为名称，可以省略()
                                      cell = new object[]
                                                     {
                                                         s.MemberNickName,
                                                         s.MemberMobilePhone,
                                                         "State",
                                                         s.CreateDate.ToDateString()
                                                      }
                                  }).ToArray();
            return Json(gridModel.PackagePageModel());
        }
    }
}
