﻿using RFrameGenerate.BLL;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Wechat;

namespace jiouosdp.Areas.WeiXinBase.Controllers
{
    public class WeiXinConfigController : Controller
    {
        //
        // GET: /WeiXinBase/WebXinConfig/

        public ActionResult Index()
        {
           var paramurl=ParameterMagage.Current.GetParameter(ParameterName.WeiXinUrl);
           var paramtoken=ParameterMagage.Current.GetParameter(ParameterName.WeiXinToken);

           ViewData["weixinurl"] = paramurl == null ? string.Empty : paramurl.ParameterValue;
           ViewData["paramtoken"] = paramtoken == null ? string.Empty : paramtoken.ParameterValue;

            return View();
        }

        public JsonResult SaveWeiXin2(string url,string token)
        {
            if (string.IsNullOrEmpty(url) || string.IsNullOrEmpty(token))
                return Json(new { Result="NO" , Msg="Url和Token不能为空"});
            try
            {
                ParameterMagage.Current.UpdateParameter(ParameterName.WeiXinUrl, url.Trim());
                ParameterMagage.Current.UpdateParameter(ParameterName.WeiXinToken, token.Trim());
                ParameterMagage.Current.Save();
                return Json(new { Result = "OK" });
            }
            catch(Exception ex)
            {
                return Json(new { Result = "NO", Msg = ex.Message });
            }
        }

        public ActionResult WeiXinInfo()
        {
            var WeiXinName = ParameterMagage.Current.GetParameter(ParameterName.WeiXinName);
            var WeiXinOpenID = ParameterMagage.Current.GetParameter(ParameterName.WeiXinOpenID);
            var WeiXinNo = ParameterMagage.Current.GetParameter(ParameterName.WeiXinNo);
            var WeiXinAppID = ParameterMagage.Current.GetParameter(ParameterName.WeiXinAppID);
            var AppsecretID = ParameterMagage.Current.GetParameter(ParameterName.AppsecretID);
            var GuanZhuLink = ParameterMagage.Current.GetParameter(ParameterName.GuanZhuLink);

            ViewData["WeiXinName"] = WeiXinName == null ? string.Empty : WeiXinName.ParameterValue;
            ViewData["WeiXinOpenID"] = WeiXinOpenID == null ? string.Empty : WeiXinOpenID.ParameterValue;
            ViewData["WeiXinNo"] = WeiXinNo == null ? string.Empty : WeiXinNo.ParameterValue;
            ViewData["WeiXinAppID"] = WeiXinAppID == null ? string.Empty : WeiXinAppID.ParameterValue;
            ViewData["AppsecretID"] = AppsecretID == null ? string.Empty : AppsecretID.ParameterValue;
            ViewData["GuanZhuLink"] = GuanZhuLink == null ? string.Empty : GuanZhuLink.ParameterValue;
            return View();
        }

        public JsonResult SaveWeiXin1(string name, string openid, string weixinno, string appid, string appsecretid, string guanZhuLinkid)
        {
            if (string.IsNullOrEmpty(name) || string.IsNullOrEmpty(openid) || string.IsNullOrEmpty(weixinno) || string.IsNullOrEmpty(appid) || string.IsNullOrEmpty(appsecretid))
                return Json(new { Result = "NO", Msg = "所有字段必填" });
            try
            {
                ParameterMagage.Current.UpdateParameter(ParameterName.WeiXinName, name.Trim());
                ParameterMagage.Current.UpdateParameter(ParameterName.WeiXinOpenID, openid.Trim());
                ParameterMagage.Current.UpdateParameter(ParameterName.WeiXinNo, weixinno.Trim());
                ParameterMagage.Current.UpdateParameter(ParameterName.WeiXinAppID, appid.Trim());
                ParameterMagage.Current.UpdateParameter(ParameterName.AppsecretID, appsecretid.Trim());
                ParameterMagage.Current.UpdateParameter(ParameterName.GuanZhuLink, guanZhuLinkid.Trim());

                WeiXinConfig.URL = ParameterMagage.Current.GetParameter<string>(ParameterName.WeiXinUrl);
                WeiXinConfig.Token = ParameterMagage.Current.GetParameter<string>(ParameterName.WeiXinToken);
                WeiXinConfig.AppId = ParameterMagage.Current.GetParameter<string>(ParameterName.WeiXinAppID);
                WeiXinConfig.AppSecret = ParameterMagage.Current.GetParameter<string>(ParameterName.AppsecretID);


                ParameterMagage.Current.Save();

                WeiXinRequest.ReadToken(true);

                return Json(new { Result = "OK" });
            }
            catch (Exception ex)
            {
                return Json(new { Result = "NO", Msg = ex.Message });
            }
        }

    }
}
