﻿using RFrameGenerate.BLL;
using RFrameGenerate.Common;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Wechat;
using weixinopen;

namespace System.Web.Mvc
{
    /// <summary>
    /// 微信分享当前页面,
    /// </summary>
    public class WeiXinShareAttribute : ActionFilterAttribute
    {
        /// <summary>
        /// 是否生成分享页面
        /// </summary>
        public bool IsShare = false;
        ///// <summary>
        ///// 手动添加
        ///// </summary>
        //public bool IsTips = true;


        /// <summary>
        /// 这是分享遮罩层上的提示文字
        /// </summary>
        public string guideStr = "这是分享遮罩层上的提示文字";
        /// <summary>
        /// 分享标题
        /// </summary>
        public string title = "惊喜";
        /// <summary>
        /// 描述
        /// </summary>
        public string desc = "好多惊喜,快来参与!";
        /// <summary>
        /// 分享图片url
        /// </summary>
        public string imgUrl = "";


        public override void OnResultExecuted(ResultExecutedContext filterContext)
        {
            if (RFrameGenerate.Common.CurrentManage.IsDebug == true)
                return;
            if (IsShare == true)
            {
                var Response = filterContext.HttpContext.Response;
                Response.Write(string.Format("<script src=\"../../Scripts/WeiXin/weixin.js\"></script><link href=\"../../Scripts/WeiXin/wx_share/wx_share.css\" rel=\"stylesheet\" /><script src=\"../../Scripts/WeiXin/wx_share/wx_share.js?t={0}\"></script>",DateTime.Now.Millisecond));
                string noncestr = RFrameGenerate.Common.ExtensionMethods.RandomEx.GenerateRandom(16);
                string timestamp = DateTimeEx.GetTimeStamp(true);
                string url = filterContext.HttpContext.Request.Url.ToString().Split('#')[0];

                string signature = WeiXinOpenRequest.Signature(url, noncestr, timestamp, RFrameGenerate.Common.CurrentManage.AppId);
                string html = string.Format("<script type=\"text/javascript\">$(function () {{$('#share').wxshare({{guideStr: '{0}',link: '{1}',title: '{2}',desc: '{3}',imgUrl: '{4}',appId: '{5}',timestamp: '{6}',nonceStr: '{7}',signature: '{8}'}});}});</script>",
                    guideStr, url, title, desc, imgUrl, CurrentManage.AppId, timestamp, noncestr, signature
                    );
                Response.Write("<div style=\"display:none\" id=\"share\"></div>");
                Response.Write(html);
            }
        }
    }
}