﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Routing;
using RFrameGenerate.BLL;
using RFrameGenerate.Common;
using RFrameGenerate.Model;
using System.Web.Param;

namespace jiouosdp.Controllers
{
    public class BaseController : Controller
    {
        #region  登录和注销

        /// <summary>
        /// 用户登录
        /// </summary>
        /// <param name="userGuid"></param>
        /// <param name="Application"></param>
        public void SignIn(Guid userGuid, Guid smerchantGuid,string appid, string userName, bool ismerchant, HttpApplicationStateBase Application)
        {

            Application.Lock();
            Hashtable hOnline = (Hashtable)Application["Online"];
            if (hOnline == null)
            {
                hOnline = Hashtable.Synchronized(new Hashtable());
                Application["Online"] = hOnline;
            }
            Application.UnLock();

            if (CurrentManage.ApplicationSignOutSwitch)
            {//多人登录时,第一次登录的失效,这里仅考虑两个人登录
                IDictionaryEnumerator idE = hOnline.GetEnumerator();
                while (idE.MoveNext())
                {
                    if (idE.Value != null && idE.Value.ToString().ToLower().Equals(userGuid.ToString().ToLower()))
                    {
                        hOnline[idE.Key] = "_repetition_";
                        break;
                    }
                }
            }
            //设置当前Session
            CurrentUser.SetCurrUser(userName, userGuid);
            CurrentUser.SetMerchant(ismerchant);
            CurrentUser.SetSMerchantGuid(smerchantGuid);
            CurrentUser.SetMerchantGuid(smerchantGuid);
            CurrentUser.SetAppID(appid);
            //设置Application
            hOnline[Session.SessionID] = userGuid;
        }

        /// <summary>
        /// 用户注销
        /// </summary>
        /// <param name="Application"></param>
        public void LoginOut(HttpContextBase HttpContext)
        {
            Hashtable hOnline = (Hashtable)HttpContext.Application["Online"];
            //注销当前Session
            CurrentUser.SetCurrUser(null, null);
            //注销Application
            if (hOnline.ContainsKey(Session.SessionID) == true)
                hOnline.Remove(Session.SessionID);


            HttpContext.Cache.Remove("_Cache_Permission_");
        }

        #endregion

        /// <summary>
        /// 错误视图
        /// </summary>
        /// <param name="msg"></param>
        /// <returns></returns>
        public ActionResult ErrorPageView(string msg = "")
        {
            ViewBag.Error = msg;
            return View();
        }

        /// <summary>
        /// 获取IP
        /// </summary>
        /// <returns></returns>
        protected string GetIP()
        {
            string ip = string.Empty;
            if (!string.IsNullOrEmpty(System.Web.HttpContext.Current.Request.ServerVariables["HTTP_VIA"]))
                ip = Convert.ToString(System.Web.HttpContext.Current.Request.ServerVariables["HTTP_X_FORWARDED_FOR"]);
            if (string.IsNullOrEmpty(ip))
                ip = Convert.ToString(System.Web.HttpContext.Current.Request.ServerVariables["REMOTE_ADDR"]);
            return ip;
        }

    }
}
