﻿using RFrameGenerate.Common;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.Mvc;
using weixinopen;

namespace jiouosdp.Controllers
{
    /// <summary>
    /// 微信分享
    /// </summary>
    public class Share
    {
        /// <summary>
        /// 
        /// </summary>
        /// <param name="curentUrl">当前url</param>
        /// <param name="url">分享后打开的url</param>
        public Share(string curentUrl, string shareOpenUrl = null)
        {
            this.curentUrl = curentUrl.Split('#')[0];
            if (shareOpenUrl == null)
                this.shareOpenUrl = curentUrl.Split('#')[0];
            else
                this.shareOpenUrl = shareOpenUrl.Split('#')[0];
        }
        /// <summary>
        /// 这是点击id=shareButton的标签后提示分享遮罩层上的提示文字
        /// </summary>
        public string guideStr = "这是分享遮罩层上的提示文字";
        /// <summary>
        /// 分享标题
        /// </summary>
        public string title = "惊喜";
        /// <summary>
        /// 描述
        /// </summary>
        public string desc = "好多惊喜,快来参与!";
        /// <summary>
        /// 分享图片url
        /// </summary>
        public string imgUrl = "";
        /// <summary>
        /// 绑定事件到前端控件,默认自动生成,赋值后,需要在html中添加id=shareButton的标签,点击会有分享提示
        /// </summary>
        public string shareButton = string.Empty;

        public string curentUrl = "";
        public string shareOpenUrl = "";


        /// <summary>
        /// 创建分享事件
        /// </summary>
        /// <param name="share"></param>
        public string CreateShareToHtml()
        {
            if (RFrameGenerate.Common.CurrentManage.IsDebug == true)
                return string.Empty;

            string html = (string.Format("<script src=\"../../Scripts/WeiXin/weixin.js\"></script><link href=\"../../Scripts/WeiXin/wx_share/wx_share.css\" rel=\"stylesheet\" /><script src=\"../../Scripts/WeiXin/wx_share/wx_share.js?t={0}\"></script>", DateTime.Now.Millisecond));
            string noncestr = RFrameGenerate.Common.ExtensionMethods.RandomEx.GenerateRandom(16);
            string timestamp = DateTimeEx.GetTimeStamp(true);

            string signature = WeiXinOpenRequest.Signature(curentUrl, noncestr, timestamp, RFrameGenerate.Common.CurrentManage.AppId);
            html += string.Format("<script type=\"text/javascript\">$(function () {{$('#share').wxshare({{guideStr: '{0}',link: '{1}',title: '{2}',desc: '{3}',imgUrl: '{4}',appId: '{5}',timestamp: '{6}',nonceStr: '{7}',signature: '{8}'}});}});</script>",
               guideStr, shareOpenUrl, title, desc, imgUrl, CurrentManage.AppId, timestamp, noncestr, signature
               );
            if (string.IsNullOrEmpty(shareButton) == true)
                html += ("<div style=\"display:none\" id=\"share\"></div>");
            else
                html += ("<div id=\"" + shareButton + "\"></div>");

            return html;
        }
    }

}