﻿using jiouosdp.Controllers;
using RFrameGenerate.BLL;
using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;


namespace jiouosdp.Common
{
    [LF(IsLoginFilter=false)]
    [PF(PCode.NoPermission)]
    public class CommonController : BaseController
    {
        //
        // GET: /Common/

        /// <summary>
        /// 根据父ID获取Area的列表
        /// </summary>
        /// <param name="rootID">父ID</param>
        /// <returns>Area的列表</returns>
        public JsonResult GetAreaList(string rootID)
        {
            List<T_BAS_Areas> areaList = new List<T_BAS_Areas>();
            areaList = AreasManage.GetAreaList(rootID);

            var jqData = (from s in areaList.OrderBy(s => s.AreaCode).ToList()
                          select new
                          {
                              Text = s.AreaName,
                              Value = s.AreaCode
                          }).ToArray();
            return Json(new { Data = jqData });
        }

        public JsonResult GetAreaTree()
        {

            string treejson = AreasManage.GetAreaTree();
            if (treejson == "[]")
                return Json(new { Result = "NO", Msg = "获取区域错误!" });
            return Json(new { Result = "OK", Data = treejson });
        }
    }
}
