﻿using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Timers;
using System.Web;

namespace jiouosdp
{
    public class CrowdfundingCar
    {
        public const string crowdfundingcar = "_crowdfundingcar_";
        public const string buy_crowdfundingcar = "_buy_crowdfundingcar_";
        #region 购物车
        public static void Save(string guids, string quantity)
        {
            var car = HttpContext.Current.Session[CrowdfundingCar.crowdfundingcar] as Cars;
            if (car != null)
            {
                var guidarr = guids.Split(new string[] { "," }, StringSplitOptions.RemoveEmptyEntries);
                var quantityarr = quantity.Split(new string[] { "," }, StringSplitOptions.RemoveEmptyEntries);
                for (int i = 0; i < guidarr.Length; i++)
                {
                    var cp = car.Products.Where(a => a.ProductCrowdPeriodGuid == Guid.Parse(guidarr[i])).FirstOrDefault();
                    if (cp != null)
                        cp.MyBuyTime = int.Parse(quantityarr[i]);
                }
            }
        }

        public static void SetCar(CrowdProduct cp)
        {
            var car = HttpContext.Current.Session[CrowdfundingCar.crowdfundingcar] as Cars;
            if (car == null)
                car = new Cars();
            lock (car)
            {
                var cpdb = car.Products.Where(a => a.ProductCrowdPeriodGuid == cp.ProductCrowdPeriodGuid).FirstOrDefault();
                if (cpdb != null)
                {
                    if (cpdb.RemainTime >= (cpdb.MyBuyTime + cp.MyBuyTime))
                        cpdb.MyBuyTime += cp.MyBuyTime;
                    else
                        cpdb.MyBuyTime = cp.RemainTime;
                }
                else
                {
                    car.Products.Add(cp);
                }
                HttpContext.Current.Session[CrowdfundingCar.crowdfundingcar] = car;
            }
        }

        public static void Del(Guid ProductCrowdPeriodGuid)
        {
            var car = HttpContext.Current.Session[CrowdfundingCar.crowdfundingcar] as Cars;

            if (car != null)
            {
                lock (car)
                {
                    car.Products.RemoveAll(a => a.ProductCrowdPeriodGuid == ProductCrowdPeriodGuid);
                }
            }
        }

        public static List<CrowdProduct> GetProduct()
        {
            var car = HttpContext.Current.Session[CrowdfundingCar.crowdfundingcar] as Cars;

            if (car == null)
            {
                return new List<CrowdProduct>();
            }
            else
            {
                return car.Products;
            }
        }

        public static void DelAll()
        {
            HttpContext.Current.Session[CrowdfundingCar.crowdfundingcar] = null;
        }

        #endregion

        #region 直接购买

        public static List<CrowdProduct> GetBuyProduct()
        {
            var car = HttpContext.Current.Session[CrowdfundingCar.buy_crowdfundingcar] as Cars;

            if (car == null)
            {
                return new List<CrowdProduct>();
            }
            else
            {
                return car.Products;
            }
        }

        public static void SetBuyCar(CrowdProduct cp)
        {
            var car = new Cars();
            car.Products.Add(cp);
            HttpContext.Current.Session[CrowdfundingCar.buy_crowdfundingcar] = car;
        }

        public static void SaveBuy(string guids, string quantity)
        {
            var car = HttpContext.Current.Session[CrowdfundingCar.buy_crowdfundingcar] as Cars;
            if (car != null)
            {
                var guidarr = guids.Split(new string[] { "," }, StringSplitOptions.RemoveEmptyEntries);
                var quantityarr = quantity.Split(new string[] { "," }, StringSplitOptions.RemoveEmptyEntries);
                for (int i = 0; i < guidarr.Length; i++)
                {
                    var cp = car.Products.Where(a => a.ProductCrowdPeriodGuid == Guid.Parse(guidarr[i])).FirstOrDefault();
                    if (cp != null)
                        cp.MyBuyTime = int.Parse(quantityarr[i]);
                }
            }
        }

        #endregion
    }
    public class Cars
    {
        Timer time;
        public Cars()
        {
            Products = new List<CrowdProduct>();
            time = new Timer();
            time.Elapsed += time_Elapsed;
            time.Enabled = true;
            time.Interval = 1000 * 60 * 6;
        }

        void time_Elapsed(object sender, ElapsedEventArgs e)
        {
            lock (Products)
            {
                for (int i = Products.Count - 1; i >= 0; i--)
                {
                    if ((DateTime.Now - Products[i].JoinDate) > new TimeSpan(0, 6, 0))
                    {
                        Products.RemoveAt(i);
                    }
                }
            }
        }
        /// <summary>
        /// 购物车商品
        /// </summary>
        public List<CrowdProduct> Products { get; set; }
    }
}