﻿using RFrameGenerate.BLL;
using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace jiouosdp.Controllers.Crowdfundings
{
    public class RAController : BaseWeiXinController
    {
        public ActionResult Index(Guid id)
        {
            ViewBag.cwid = id;
            return View();
        }

        public ActionResult Add(Guid id,int d = 0)
        {
            ViewBag.cwid = id;
            return View();
        }

        public JsonResult AddAddress(T_BAS_RecieverAddress address)
        {
            var result = RecieverAddressManage.Add(address);
            if (result.State == true)
                return Json(new { Result = "OK", id = address.RecieverAddressGuid });
            else
                return Json(new { Result = "NO", Msg = result.Msg });
        }

        public ActionResult Update(Guid id,Guid cwid)
        {
            ViewBag.cwid = cwid;
            ViewBag.Address = RecieverAddressManage.GetREcieverAdddressByGuid(id);
            return View();
        }

        public JsonResult UpdateAddress(T_BAS_RecieverAddress address)
        {
            var result = RecieverAddressManage.Update(address);
            if (result.State == true)
                return Json(new { Result = "OK" });
            else
                return Json(new { Result = "NO", Msg = result.Msg });
        }

        public JsonResult DeleteAddress(Guid id)
        {
            var result = RecieverAddressManage.Delete(id);
            if (result.State == true)
                return Json(new { Result = "OK" });
            else
                return Json(new { Result = "NO", Msg = result.Msg });
        }

        public JsonResult DefaultAddress(Guid id)
        {
            var result = RecieverAddressManage.DefaultAddress(id);
            if (result.State == true)
                return Json(new { Result = "OK" });
            else
                return Json(new { Result = "NO", Msg = result.Msg });
        }

        public JsonResult SaveRa(Guid cwid,Guid addreid)
        {
            var result = CrowdWinManage.SaveRa(cwid, addreid);

            if (result.State == true)
                return Json(new { Result = "OK" });
            else
                return Json(new { Result = "NO", Msg = result.Msg });
        }
    }
}
