﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using RFrameGenerate.BLL;
using RFrameGenerate.BLL.Organization;
using RFrameGenerate.Common;
using RFrameGenerate.Model;
using jiouosdp.Controllers;
using System.Net;
using System.Drawing;

namespace jiouosdp.Controllers
{
    [LF(IsLoginFilter = false)]
    [PF(IsPermissionFilter = false)]
    public class HomeController : BaseController
    {
        [LF(IsLoginFilter = true)]
        [PF(IsPermissionFilter = false)]
        public ActionResult Index()
        {
            return View();
        }

        public ActionResult Load()
        {
            return View();
        }

        public ActionResult AdminIndex()
        { 	
            if (CurrentUser.GetCurrUserGuid() != Guid.Empty)
            {
                return Redirect("/theme/main/control");
            }

            return View();
        }

        public ActionResult LoginValid(string loginName, string Password)
        {
            //if (loginName != "sym") return Json(new { Result = "NO", Data = "临时账号暂不开放" });
            try
            {
                string oldPwd = Password;
                Password = RFramework.MD5Crypto.MD5(Password);
                string appid = string.Empty;
                if (CurrentUser.GetCurrUserGuid() == Guid.Empty)
                {
                    if (Request.Url.ToString().Contains("http://manage.") == true || (Request.Url.ToString().Contains("http://localhost") && loginName == "jioukeji"))
                    {
                        #region 总部
                        T_BAS_Agents user;
                        var result = AgentManage.IsValid(loginName, Password, oldPwd, out user);
                        if (result.State == true)
                        {
                            if (user.UserType == DictionaryConst.LoginType.Agent)
                                return Json(new { Result = "NO", Data = "账号不存在" });
                            if (user.IsEnable != true)
                                return Json(new { Result = "NO", Data = "账号已关闭" });

                            CurrentUser.SetLoginType(user.UserType);
                            CurrentUser.SetMerchantUserID(user.UserID);
                            CurrentUser.SetMerchantType(user.UserType);
                            SignIn(user.AgentGuid, user.AgentGuid, appid, user.UserID, true, HttpContext.Application);
                            return Json(new { Result = "OK", Data = "/theme/main/Agent" });//没有打开上次打开的页面,在control打开
                        }
                        else
                        {
                            return Json(new { Result = "NO", Data = result.Msg });
                        }
                        #endregion
                    }
                    else if (Request.Url.ToString().Contains("http://agent.") == true || Request.Url.ToString().Contains(".oemagent.") == true || (Request.Url.ToString().Contains("http://localhost") && loginName == "testxl"))
                    {
                        #region 代理
                        T_BAS_Agents user;
                        var result = AgentManage.IsValid(loginName, Password, oldPwd, out user);
                        if (result.State == true)
                        {
                            if (user.UserType == DictionaryConst.LoginType.HeadOffice)
                                return Json(new { Result = "NO", Data = "账号不存在" });
                            if (user.IsEnable != true)
                                return Json(new { Result = "NO", Data = "账号已关闭" });

                            CurrentUser.SetLoginType(user.UserType);
                            CurrentUser.SetMerchantUserID(user.UserID);
                            CurrentUser.SetMerchantType(user.UserType);
                            SignIn(user.AgentGuid, user.AgentGuid, appid, user.UserID, true, HttpContext.Application);
                            return Json(new { Result = "OK", Data = "/theme/main/Agent" });//没有打开上次打开的页面,在control打开
                        }
                        else
                        {
                            return Json(new { Result = "NO", Data = result.Msg });
                        }
                        #endregion
                    }
                    else
                    {
                        #region 商家/员工
                        if (loginName.IndexOf("@") > 2)
                        {//员工登录
                            T_ST_User user;
                            var result = UserManage.IsValid(loginName, Password, out user);
                            if (result.State == true)
                            {
                                CurrentUser.SetLoginType(DictionaryConst.LoginType.Employee);
                                var merchant = MerchantManage.GetMerchant(user.MerchantGuid.Value);


                                if (merchant.IsEnable != true)
                                    return Json(new { Result = "NO", Data = "商家已关闭" });

                                if (merchant.WeChatGuid != null)
                                {
                                    var wetch = WeChatManage.GetWeChatByMearchantID(merchant.WeChatGuid.Value);
                                    if (wetch != null)
                                        appid = wetch.appid;
                                }

                                CurrentUser.SetMerchantUserID(merchant.UserID);
                                CurrentUser.SetMerchantType(merchant.UserType.Value);
                                SignIn(user.UserGuid, merchant.MerchantGuid, appid, user.UserName, false, HttpContext.Application);
                                return Json(new { Result = "OK", Data = "/theme/main/control" });//没有打开上次打开的页面,在control打开
                            }
                            else
                            {
                                return Json(new { Result = "NO", Data = result.Msg });
                            }
                        }
                        else
                        {
                            T_BAS_Merchants user;
                            var result = MerchantManage.IsValid(loginName, Password, oldPwd, out user);
                            if (result.State == true)
                            {
                                if (user.IsEnable != true)
                                    return Json(new { Result = "NO", Data = "商家已关闭" });
                                CurrentUser.SetLoginType(DictionaryConst.LoginType.Merchant);
                                if (user.WeChatGuid != null)
                                {
                                    var wetch = WeChatManage.GetWeChatByMearchantID(user.WeChatGuid.Value);
                                    if (wetch != null)
                                        appid = wetch.appid;
                                }
                                CurrentUser.SetMerchantUserID(user.UserID);
                                CurrentUser.SetMerchantType(user.UserType.Value);
                                SignIn(user.MerchantGuid, user.MerchantGuid, appid, user.UserID, true, HttpContext.Application);

                                return Json(new { Result = "OK", Data = "/theme/main/control" });//没有打开上次打开的页面,在control打开
                            }
                            else
                            {
                                return Json(new { Result = "NO", Data = result.Msg });
                            }
                        }
                        #endregion
                    }
                }
                else
                {
                    return Json(new { Result = "OK", Data = "/theme/main/control" });
                }
            }
            catch (Exception e)
            {
                return Json(new { Result = "Error", Data = e.Message });
            }

        }

        public ActionResult Logout()
        {
            LoginOut(HttpContext);
            return Redirect("AdminIndex");
        }
        
        [LF(IsLoginFilter = false, IsMaintenance = false)]
        public ActionResult Maintenance()
        {
            return View();
        }

    }
}
