﻿using jiouosdp.Areas.Marketing.Models;
using RFrameGenerate.BLL.Marketing;
using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace jiouosdp.Controllers.WX
{
    public class CouponsController : BaseWeiXinController
    {
        // GET: /Coupons/
        public ActionResult Index(Guid? couponGuid)
        {
            var list = StoreActivityManage.GetAvailableActivities(couponGuid);

            if (list == null) return View(new List<T_ST_ActivityCoupons>(0));

            return View(list);
        }

        public ActionResult MyCoupons(int? state)
        {
            var list = ActivityDetailManage.GetMyCoupons(this.GetCurrentMember().MemberGuid, state);

            ViewBag.AvailableCoupons = ActivityDetailManage.GetAvailableCoupons(this.GetCurrentMember().MemberGuid);

            return View(list);
        }

        #region 逻辑处理

        public JsonResult GetCoupons(Guid activityGuid, Guid couponsGuid)
        {
            int resultNum = 0;
            var result = StoreCouponsManage.GetCoupons(activityGuid, couponsGuid, GetCurrentMember().MemberGuid, out resultNum);

            if (!result.State) return Json(new { Result = "NO", Msg = result.Msg });

            return Json(new { Result = "OK", ResultNum = resultNum });
        }

        #endregion
    }
}
