﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using RFrameGenerate.BLL;
using RFrameGenerate.Model;
using System.Net;
using RFrameGenerate.BLL.Products;
using RFrameGenerate.Common;
using Wechat;
using RFrameGenerate.BLL.Recharge;

namespace jiouosdp.Controllers.WX
{
    public class MyController : BaseWeiXinController
    {
        //
        // GET: /My/

        public ActionResult Index()
        {
            return View();
        }

        public ActionResult EditMember()
        {
            return View();
        }

        public ActionResult CheckSecurity()
        {
            return View();
        }
        public JsonResult SaveMember(T_BAS_Member member)
        {
            var result = MemberManage.Update(member);
            if (result.State == true)
            {
                return Json(new { Result = "OK" });
            }
            else
            {
                return Json(new { Result = "NO", Msg = result.Msg });
            }
        }

        public ActionResult Withdraws()
        {
            return View();
        }

        public ActionResult WithdrawsRecord()
        {
            return View();
        }

        public ActionResult WithdrawsApply()
        {
            return View();
        }
        public JsonResult ApplyAmount(string name, string tel, decimal amount)
        {
            var result = WithdrawsManage.ApplyAmoutn(name, tel, amount, OpenID, "微信钱包");
            if (result.State == true)
            {
                return Json(new { Result = "OK" });
            }
            else
            {
                return Json(new { Result = "NO", Msg = result.Msg });
            }
        }

        public JsonResult CheckProductSecurity(string securityCode, Guid productGuid)
        {

            var list = ProductAntiFakeManage.GetAntiFakesList(securityCode, productGuid);
            if (list.Count > 0 && list[0].CheckNum > 1)
            {
                return Json(new { Result = "OK", Msg = "此商品已经通过验证" });
            }
            else if (list.Count > 0)
            {
                ProductAntiFakeManage.SetCheckSecurity(securityCode, productGuid);

                return Json(new { Result = "OK", Msg = "商品验证成功，商品是正品" });
            }
            else
            {
                return Json(new { Result = "NO", Msg = "商品不存在，请检查您输入的防伪码是否正确！" });
            }
        }

        public JsonResult GetProductList()
        {
            return Json(ProductsManage.GetAllList());

        }

        #region 用户等级

        public ActionResult MyLevel()
        {
            return View();
        }

        #endregion

        #region 充值

        public ActionResult Recharge()
        {
            return View();
        }

        public JsonResult SubmitRechargeOrder(string name, string phone, decimal amount)
        {
            string orderNo = string.Empty;

            var result = RechargeManage.SubmitOrder(name, phone, amount, out orderNo);

            if (!result.State) return Json(new { Result = "NO", Msg = result.Msg });

            return Json(new { Result = "OK", OrderNo = orderNo });
        }

        public ActionResult RechargeRecord()
        {
            return View();
        }

        public JsonResult GetRechargeRecordList(int page, int rows, int? type)
        {
            var list = RechargeRecordManage.GetPageList(new GridModel() { page = page, rows = rows }, type);

            if (list == null || list.Count <= 0) return Json(new { Result = "NO" });

            return Json(new { Result = "OK", Page = page + 1, List = list });
        }
        #endregion
    }
}
