﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using RFrameGenerate.Model;
using System.Web.Script.Serialization;
using RFrameGenerate.BLL;
using RFrameGenerate.Common;
using weixinopen;

namespace jiouosdp.Controllers.WX
{
    public class RecieverAddressController : BaseWeiXinController
    {
        //
        // GET: /RecieverAddress/

        [WeiXinLoginAttribute(IsAutoLogin = false, IsAuthorization = false)]//自动登录
        public ActionResult SelectAdd(int o = 0)
        {
            string auturl = WeiXinOpenRequest.GetOAuthoUrl2(WeiXinOpenConfig.webdomain.Replace("appid", CurrentManage.AppId) + string.Format("RecieverAddress/RACall?o={0}&userid={1}",
                o, CurrentManage.MerchantUserID), "author", CurrentManage.AppId, Wechat.Enum.Scope.snsapi_base);

            return Redirect(auturl);
        }

        [WeiXinLoginAttribute(IsAutoLogin = false, IsAuthorization = false)]//自动登录
        public ActionResult RACall(string code, string state, string appid, string userid, int o = 0)
        {
            ComponentAccessToken webToken = WeiXinOpenRequest.get_access_token(code, appid);
            ViewBag.access_token = webToken.access_token;
            ViewBag.userid = userid;
            ViewBag.appid = appid;
            ViewBag.openid = webToken.openid;
            return View();
        }
        [WeiXinLoginAttribute(IsAutoLogin = false, IsAuthorization = false)]//自动登录
        public JsonResult ApiAdd(string openid,string username, string telNumber, string addressPostalCode, string proviceFirstStageName, string addressCitySecondStageName, string addressCountiesThirdStageName, string addressDetailInfo, string nationalCode)
        {
            Guid RecieverAddressGuid;
            var result = RecieverAddressManage.ApiAdd(out RecieverAddressGuid,openid,username, telNumber, addressPostalCode, proviceFirstStageName, addressCitySecondStageName, addressCountiesThirdStageName, addressDetailInfo, nationalCode);
            if (result.State == true)
                return Json(new { Result = "OK", id = RecieverAddressGuid });
            else
                return Json(new { Result = "NO", Msg = result.Msg });
        }

        public ActionResult Index(int o = 0)
        {
            ViewBag.o = o;
            return View();
        }

        public ActionResult Add(int d = 0, int o = 0)
        {
            ViewBag.o = o;
            ViewBag.d = d;
            return View();
        }

        public JsonResult AddAddress(T_BAS_RecieverAddress address)
        {
            var result = RecieverAddressManage.Add(address);
            if (result.State == true)
                return Json(new { Result = "OK", id = address.RecieverAddressGuid });
            else
                return Json(new { Result = "NO", Msg = result.Msg });
        }

        public ActionResult Update(Guid id, int o = 0)
        {
            ViewBag.Address = RecieverAddressManage.GetREcieverAdddressByGuid(id);
            ViewBag.o = o;
            return View();
        }

        public JsonResult UpdateAddress(T_BAS_RecieverAddress address)
        {
            var result = RecieverAddressManage.Update(address);
            if (result.State == true)
                return Json(new { Result = "OK" });
            else
                return Json(new { Result = "NO", Msg = result.Msg });
        }

        public JsonResult DeleteAddress(Guid id)
        {
            var result = RecieverAddressManage.Delete(id);
            if (result.State == true)
                return Json(new { Result = "OK" });
            else
                return Json(new { Result = "NO", Msg = result.Msg });
        }

        public JsonResult DefaultAddress(Guid id)
        {
            var result = RecieverAddressManage.DefaultAddress(id);
            if (result.State == true)
                return Json(new { Result = "OK" });
            else
                return Json(new { Result = "NO", Msg = result.Msg });
        }

    }
}
