﻿using RFrameGenerate.BLL;
using RFrameGenerate.Common;
using RFramework.Licenses;
using System;
using System.Collections.Generic;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Threading;
using System.Web;
using System.Web.Mvc;
using System.Web.Routing;
using System.Xml;
using Wechat;
using Wechat.Model;
using weixinopen;
namespace jiouosdp
{
    public class MvcApplication : System.Web.HttpApplication
    {
        public static void RegisterGlobalFilters(GlobalFilterCollection filters)
        {
            filters.Add(new HandleErrorAttribute());
        }

        public static void RegisterRoutes(RouteCollection routes)
        {
            routes.IgnoreRoute("{resource}.axd/{*pathInfo}");
            routes.MapRoute(
                "Default",
                "{controller}/{action}/{id}",
                new { controller = "Home", action = "AdminIndex", id = UrlParameter.Optional },
                namespaces: new string[] { "jiouosdp.Controllers" }
            );

            routes.Add("DomainRoute", new DomainRoute(
                "{companyUrl}.jioukeji.com",   
                "{controller}/{action}/{id}",   
                new { companyUrl = "", controller = "Home", action = "Login", id = "" }  
                ));
        }

        protected void Application_Start()
        {
            AreaRegistration.RegisterAllAreas();
            GlobalFilters.Filters.Add(new LF());
            GlobalFilters.Filters.Add(new PF());
#if! DEBUG
            GlobalFilters.Filters.Add(new MvcExceptionLogAttribute());
#endif
            RegisterGlobalFilters(GlobalFilters.Filters);
            RegisterRoutes(RouteTable.Routes);
            SetSystem();
            SetWeiXin();
            Debug();
        }

        class A
        {
            public Guid? AA { get; set; }
        }

        protected void Application_End(object sender, EventArgs e)
        {
            CrowdPeriodLock.Stop();
        }
        void SetSystem()
        {
            #region 系统配置

            WebManage.filepath = Server.MapPath("~/Function.config");
            WebManage.Read();

            RFrameGenerate.Common.CurrentManage.IsDebug = System.Configuration.ConfigurationManager.AppSettings["Debug"].ToString().ToLower() == "true" ? true : false;
            RFrameGenerate.Common.CurrentManage.IsMaintenance = System.Configuration.ConfigurationManager.AppSettings["Maintenance"].ToString().ToLower() == "true" ? true : false;

            MvcLog.MvcLogFolder = Server.MapPath(System.Configuration.ConfigurationManager.AppSettings["LogPath"].ToString());
            RFrameGenerate.Common.DatabaseConfig.Database.InitConnection(System.Configuration.ConfigurationManager.ConnectionStrings["connectionString"].ToString());
            RFrameGenerate.Common.CurrentManage.ObjectTitle = System.Configuration.ConfigurationManager.AppSettings["ObjectTitle"].ToString();
            RFrameGenerate.Common.CurrentManage.Domain = System.Configuration.ConfigurationManager.AppSettings["Domain"].ToString();
            RFrameGenerate.Common.CurrentManage.DomainWx = System.Configuration.ConfigurationManager.AppSettings["DomainWx"].ToString();
            RFrameGenerate.Common.CurrentManage.DomainWxRoot = System.Configuration.ConfigurationManager.AppSettings["DomainWxRoot"].ToString();

            RFrameGenerate.Common.CurrentManage.OfflineLoginResult = System.Configuration.ConfigurationManager.AppSettings["OfflineLoginResult"].ToString();
            RFrameGenerate.Common.CurrentManage.ApplicationSignOutSwitch = Convert.ToBoolean(System.Configuration.ConfigurationManager.AppSettings["ApplicationSignOutSwitch"].ToString());
            RFrameGenerate.Common.CurrentManage.IsEnableApi =false;
            RFrameGenerate.Common.CurrentManage.AuthorizationDay = int.Parse(System.Configuration.ConfigurationManager.AppSettings["AuthorizationDay"].ToString());
            RFrameGenerate.Common.CurrentManage.ContributionInnerTime = int.Parse(System.Configuration.ConfigurationManager.AppSettings["contribution_innerTime"].ToString());
            LicenseUtils.RegisterLicense("liuyi-eyJJRCI6ImxpdXL9SlpIiwiTmFtZSI6IuW5v+W3nuaegeasp+S/oeaBr+enkeaKgOaciemZkOWFrOWPuCIsIkV4cGlyZSI6IjIwMjAvMDYvMDEgMDA6MDA6MDAiLCJTdGFydERhdGEiOiIyMDE2LzA2LzAxIDE1OjUyOjQ2IiwiQmluZERvbWFpbiI6IiIsIlR5cGUiOiJCdXNpbmVzcyIsIkhhc2giOiJGVzA0TEU4TlU2VW9hakJsNGZNdzEwcXlyZlVsYm1mVWpvcncwa24wTlVVQk15ZFcyaXdvYWh5VGFWNmxNMmtvK0xDVnFXNGUyd0NGaHUwcER2NUZmalBMbE1oR0h5YXlYZERmNnkvVkR3dkI3SmNQZmx6MzdDbnZUUDQ1eHAzRCtvSlJSSjFteCtZclNVTHZsbGZZRklOVVVLMnp5d3VwbVViQVVhT0RLdTA9In0=");
            
            #endregion

            #region 默认添加数据,添加权限
            //管理员唯一标识
            RFrameGenerate.Common.CurrentUser.AdminIdentification = Guid.Parse(System.Configuration.ConfigurationManager.AppSettings["Admin"].ToString());
            //添加权限码到数据<开发>(注意:如果存在Admin用户,则不会添加)
            RFrameGenerate.BLL.PermissionManage.AddPerssionCodeDatabase();
            #endregion

            CrowdPeriodLock.Start();
        }

        void SetWeiXin()
        {
            LogManage.Path = Server.MapPath(System.Configuration.ConfigurationManager.AppSettings["LogPath"].ToString());

            #region 开放平台配置
            WeiXinOpenConfig.ConfigPath = Server.MapPath(System.Configuration.ConfigurationManager.AppSettings["ConfigPath"].ToString());
            WeiXinOpenConfig.component_appid = System.Configuration.ConfigurationManager.AppSettings["component_appid"].ToString();
            WeiXinOpenConfig.component_appsecret = System.Configuration.ConfigurationManager.AppSettings["component_appsecret"].ToString();
            WeiXinOpenConfig.component_token = System.Configuration.ConfigurationManager.AppSettings["component_token"].ToString();
            WeiXinOpenConfig.component_Key = System.Configuration.ConfigurationManager.AppSettings["component_Key"].ToString();
            string webdomani = System.Configuration.ConfigurationManager.AppSettings["webdomain"].ToString();
            if (webdomani.EndsWith("/"))
                WeiXinOpenConfig.webdomain = webdomani;
            else
                WeiXinOpenConfig.webdomain = webdomani + "/";

            WeiXinOpenRequest.ReadComponent_Access_Toke();
            #endregion

            ApiTranAppIdList.Path = Server.MapPath("~/ApiTranAppIdList.config");
            ApiTranAppIdList.Start();
            ApiTranAppIdList.ReadConfig();
        }

        void Debug()
        {
            #region Rframword Debug下自动写日志

#if DEBUG
            RFramework.Log.LogFolder = Server.MapPath(System.Configuration.ConfigurationManager.AppSettings["LogPath"].ToString());
            RFramework.Log.IsDebug = true;
#else
            RFramework.Log.IsDebug = false;
#endif
            #endregion

            #region 测试微信 false;
            RFrameGenerate.Common.CurrentManage.TestAppId = System.Configuration.ConfigurationManager.AppSettings["TestAppId"].ToString();
            RFrameGenerate.Common.CurrentManage.TestUserID = System.Configuration.ConfigurationManager.AppSettings["TestUserID"].ToString();
            RFrameGenerate.Common.CurrentManage.TestAppSecret = System.Configuration.ConfigurationManager.AppSettings["TestAppSecret"].ToString();
            RFrameGenerate.Common.CurrentManage.TestEncodingAESKey = System.Configuration.ConfigurationManager.AppSettings["TestEncodingAESKey"].ToString();
            RFrameGenerate.Common.CurrentManage.TestMemberGuid = Guid.Parse(System.Configuration.ConfigurationManager.AppSettings["TestMemberGuid"].ToString());
            RFrameGenerate.Common.CurrentManage.TestMemberOpenID = System.Configuration.ConfigurationManager.AppSettings["TestMemberOpenID"].ToString();
            RFrameGenerate.Common.CurrentManage.TestToken = System.Configuration.ConfigurationManager.AppSettings["TestToken"].ToString();
            RFrameGenerate.Common.CurrentManage.TestUserName = System.Configuration.ConfigurationManager.AppSettings["TestUserName"].ToString();
            #endregion
        }

    }

}
