﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace jiouosdp.Models
{
    public class BasePageModel
    {
        public string CheckedHtml
        {
            get
            {
                return "checked=\"checked\"";
            }
        }

        public string StyleHideHtml
        {
            get
            {
                return "style=\"display:none\"";
            }
        }

        public string GetDateString(DateTime? date)
        {
            if (date == null) return string.Empty;

            return date.Value.ToString("yyyy-MM-dd");
        }

        public string GetDateTimeString(DateTime? date)
        {
            if (date == null) return string.Empty;

            return date.Value.ToString("yyyy-MM-dd HH:mm:ss");
        }

        public string GetAmountString(decimal? amount)
        {
            return GetAmountString(amount, "N02");
        }

        public string GetAmountString(decimal? amount, string format)
        {
            if (amount == null) return string.Empty;

            return amount.Value.ToString(format);
        }

        public string GetIntegerString(int? integer)
        {
            if (integer == null) return string.Empty;

            return integer.Value.ToString();
        }
    }
}