﻿using RFrameGenerate.BLL;
using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace jiouosdp.Models
{
    public class ProductCrowdModel
    {
        public T_CR_ProductCrowdPeriods CrowdPeriods { get; set; }

        private T_CR_ProductCrowd _crowd = null;
        public T_CR_ProductCrowd Crowd
        {
            get
            {
                if (_crowd != null) return _crowd;

                _crowd = ProductCrowdManage.GetProductCrowd(this.CrowdPeriods.ProductCrowdGuid);

                if (_crowd == null) _crowd = new T_CR_ProductCrowd();

                return _crowd;
            }
        }

        private string _firstTime = null;
        public string FirstTime
        {
            get
            {
                if (!string.IsNullOrEmpty(_firstTime)) return _firstTime;

                var model = CrowdParticipateManage.GetFirstParticipate(this.CrowdPeriods.ProductCrowdPeriodGuid);

                if (model == null) return "";

                return model.CrowdDate.ToString("yyyy-MM-dd HH:mm:ss");
            }
        }

        public static List<ProductCrowdModel> ForList(List<T_CR_ProductCrowdPeriods> list)
        {
            List<ProductCrowdModel> r_list = new List<ProductCrowdModel>();

            foreach (var item in list)
            {
                r_list.Add(new ProductCrowdModel()
                {
                    CrowdPeriods = item
                });
            }
         
            return r_list;
        }
    }
}