﻿; (function ($) {
    $.extend({
        AreaMap: function (provinceid, cityid, areaid) {
            var cityid = cityid;
            var provinceid = provinceid;
            var areaid = areaid;
            var cityname;
            var provincename;
            var areaname;

            var $provinceid = $("#" + provinceid);
            var $cityid = $("#" + cityid);
            var $areaid = $("#" + areaid);
           
            $provinceid.change(function () {
                cityFunc($(this).val());
            });

            $cityid.change(function () {
                areaFunc($(this).val());
            });

            cityFunc = function (provinceValue, func) {
                
                $cityid.empty().append('<option value="">-城市-</option>');
                $areaid.empty().append('<option value="">-县区-</option>');

                if (provinceValue == "") {
                    return false;
                }
                if (provinceValue != undefined) {
                    var jsonObj = new Object();
                    jsonObj.rootID = provinceValue;
                    $.ajax({
                        type: "post",
                        url: "/Common/GetAreaList",
                        data: JSON.stringify(jsonObj),
                        global: false,
                        dataType: "json",
                        contentType: "application/json; charset=utf-8",
                        success: function (context) {

                            $.each(context.Data, function () {
                                $cityid.append('<option value="' + this.Value + '">' + this.Text + '</option>');
                            });
                            if (func != undefined) {
                                func();
                            }
                        }
                    });
                } else { return false; }

            }

            areaFunc = function (cityValue, func) {

                $areaid.empty().append('<option value="">-县区-</option>');
                if (cityValue == "") {
                    return false;
                }
                if (cityValue != undefined) {
                    var jsonObj = new Object();
                    jsonObj.rootID = cityValue;
                    $.ajax({
                        type: "post",
                        url: "/Common/GetAreaList",
                        data: JSON.stringify(jsonObj),
                        global: false,
                        dataType: "json",
                        contentType: "application/json; charset=utf-8",
                        success: function (context) {

                            $.each(context.Data, function () {
                                $areaid.append('<option value="' + this.Value + '">' + this.Text + '</option>');
                            });
                            if (func != undefined) {
                                func();
                            }
                        }
                    });
                } else { return false; }

            }

            return {
                initialize_txt: function (provincename, cityname, areaname) {
                    var provincevalue;
                    var cityvalue;
                    var areavalue;
                    var jsonObj = new Object();
                    jsonObj.rootID = 0;
                    $.ajax({
                        type: "post",
                        url: "/Common/GetAreaList",
                        global: false,
                        dataType: "json",
                        data: JSON.stringify(jsonObj),
                        contentType: "application/json; charset=utf-8",
                        success: function (context) {
                            $provinceid.empty().append('<option value="">-省份-</option>');
                            $.each(context.Data, function () {
                                $provinceid.append('<option value="' + this.Value + '">' + this.Text + '</option>');
                            });
                            if (provincename == undefined) {//表示默认选中
                                $cityid.empty().append('<option value="">-城市-</option>');
                                $areaid.empty().append('<option value="">-县区-</option>');
                            } else {
                                //$provinceid.val(provincename);
                                var isprovince = false;
                                $("#" + provinceid + " option").each(function () {
                                    if ($(this).text() == provincename) {
                                        provincevalue = $(this).val();
                                        $(this).attr("selected", true);
                                    }
                                });
                                if (!isprovince) {
                                    $("#" + provinceid).prepend("<option value=" + provincename + ">" + provincename + "</option>");
                                    $("#" + provinceid + " option:first").attr("selected", true);

                                    $("#" + cityid).prepend("<option value=" + cityname + ">" + cityname + "</option>");
                                    $("#" + cityid + " option:first").attr("selected", true);

                                    $("#" + areaid).prepend("<option value=" + areaname + ">" + areaname + "</option>");
                                    $("#" + areaid + " option:first").attr("selected", true);

                                } else {
                                    cityFunc(provincevalue, function () {
                                        //$cityid.val(cityname);
                                        var iscity = false;
                                        $("#" + cityid + " option").each(function () {
                                            if ($(this).text() == cityname) {
                                                cityvalue = $(this).val();
                                                $(this).attr("selected", true);
                                            }
                                        });
                                        if (!iscity) {
                                            $("#" + cityid).prepend("<option value=" + cityname + ">" + cityname + "</option>");
                                            $("#" + cityid + " option:first").attr("selected", true);

                                            $("#" + areaid).prepend("<option value=" + areaname + ">" + areaname + "</option>");
                                            $("#" + areaid + " option:first").attr("selected", true);

                                        } else {
                                            areaFunc(cityvalue, function () {
                                                //$areaid.val(areaname);
                                                var isarea = false;
                                                $("#" + areaid + " option").each(function () {
                                                    if ($(this).text() == areaname) {
                                                        $(this).attr("selected", true);
                                                    }
                                                });
                                                if (!isarea) {
                                                    $("#" + areaid).prepend("<option value=" + areaname + ">" + areaname + "</option>");
                                                    $("#" + areaid + " option:first").attr("selected", true);
                                                }
                                            });
                                        }
                                    });
                                }
                            }
                        }
                    });
                },
                initialize_val: function (provincevalue, cityvalue, areavalue) {
                    var jsonObj = new Object();
                    jsonObj.rootID = 0;
                    $.ajax({
                        type: "post",
                        url: "/Common/GetAreaList",
                        global: false,
                        dataType: "json",
                        data: JSON.stringify(jsonObj),
                        contentType: "application/json; charset=utf-8",
                        success: function (context) {
                            $provinceid.empty().append('<option value="">-省份-</option>');
                            $.each(context.Data, function () {
                                $provinceid.append('<option value="' + this.Value + '">' + this.Text + '</option>');
                            });
                            if (!provincevalue) {//表示默认选中
                                $cityid.empty().append('<option value="">-城市-</option>');
                                $areaid.empty().append('<option value="">-县区-</option>');
                            } else {
                                $provinceid.val(provincevalue);
                                cityFunc(provincevalue, function () {
                                        $cityid.val(cityvalue);
                                    areaFunc(cityvalue, function () {
                                            $areaid.val(areavalue);
                                    });
                                });
                            }
                        }
                    });
                }
            }
        }
    });
})(jQuery);

var MapArr = new Array();

var AreaMap = function (provinceid, cityid, areaid,type) {
    var cityname;
    var provincename;
    var areaname;

    if (!type) {
        type = "Name";
    }

    if (type == "ID") {
        var $provinceid = $("[name='" + provinceid + "']");
        var $cityid = $("[name='" + cityid + "']");
        var $areaid = $("[name='" + areaid + "']");
    } else {
        var $provinceid = $("#" + provinceid);
        var $cityid = $("#" + cityid);
        var $areaid = $("#" + areaid);
    }
    
    var Obj = new Object();
    Obj.provinceid = $provinceid;
    Obj.cityid = $cityid;
    Obj.areaid = $areaid;
    MapArr.push(Obj);

    $provinceid.change(function () {
        var value = $(this).val();
        //var name = $(this)[0].name;
        var id = $(this).attr("id");
        $.each(MapArr, function () {
            if (this.provinceid.attr("id") == id) {
                cityFunc(this, value);
                return false;
            }
        });
    });

    $cityid.change(function () {
        var value = $(this).val();
        var id = $(this).attr("id");
        //var name = $(this)[0].name;
        $.each(MapArr, function () {
            if (this.cityid.attr("id") == id) {
                areaFunc(this, value);
                return false;
            }
        });
        
    });

    cityFunc = function (objList,provinceValue, func) {

        objList.cityid.empty().append('<option value="">-城市-</option>');
        objList.areaid.empty().append('<option value="">-县区-</option>');

        if (provinceValue == "") {
            return false;
        }
        if (provinceValue != undefined) {
            var jsonObj = new Object();
            jsonObj.rootID = provinceValue;
            $.ajax({
                type: "post",
                url: "/Common/GetAreaList",
                data: JSON.stringify(jsonObj),
                global: false,
                dataType: "json",
                contentType: "application/json; charset=utf-8",
                success: function (context) {

                    $.each(context.Data, function () {
                        objList.cityid.append('<option value="' + this.Value + '">' + this.Text + '</option>');
                    });
                    if (func != undefined) {
                        func();
                    }
                }
            });
        } else { return false; }

    }

    areaFunc = function (objList,cityValue, func) {

        objList.areaid.empty().append('<option value="">-县区-</option>');
        if (cityValue == "") {
            return false;
        }
        if (cityValue != undefined) {
            var jsonObj = new Object();
            jsonObj.rootID = cityValue;
            $.ajax({
                type: "post",
                url: "/Common/GetAreaList",
                data: JSON.stringify(jsonObj),
                global: false,
                dataType: "json",
                contentType: "application/json; charset=utf-8",
                success: function (context) {

                    $.each(context.Data, function () {
                        objList.areaid.append('<option value="' + this.Value + '">' + this.Text + '</option>');
                    });
                    if (func != undefined) {
                        func();
                    }
                }
            });
        } else { return false; }

    }

    return {
        initialize_txt: function (provincename, cityname, areaname) {
            var provincevalue;
            var cityvalue;
            var areavalue;
            var jsonObj = new Object();
            jsonObj.rootID = 0;
            $.ajax({
                type: "post",
                url: "/Common/GetAreaList",
                global: false,
                dataType: "json",
                data: JSON.stringify(jsonObj),
                contentType: "application/json; charset=utf-8",
                success: function (context) {
                    $provinceid.empty().append('<option value="">-省份-</option>');
                    $.each(context.Data, function () {
                        $provinceid.append('<option value="' + this.Value + '">' + this.Text + '</option>');
                    });
                    if (provincename == undefined) {//表示默认选中
                        $cityid.empty().append('<option value="">-城市-</option>');
                        $areaid.empty().append('<option value="">-县区-</option>');
                    } else {
                        //$provinceid.val(provincename);
                        var isprovince = false;
                        $("#" + provinceid + " option").each(function () {
                            if ($(this).text() == provincename) {
                                provincevalue = $(this).val();
                                $(this).attr("selected", true);
                                isprovince = true;
                                return false;
                            }
                        });
                        if (!isprovince) {
                            $("#" + provinceid).prepend("<option value=" + provincename + ">" + provincename + "</option>");
                            $("#" + provinceid + " option:first").attr("selected", true);

                            $("#" + cityid).prepend("<option value=" + cityname + ">" + cityname + "</option>");
                            $("#" + cityid + " option:first").attr("selected", true);

                            $("#" + areaid).prepend("<option value=" + areaname + ">" + areaname + "</option>");
                            $("#" + areaid + " option:first").attr("selected", true);

                        } else {
                            cityFunc(Obj, provincevalue, function () {
                                //$cityid.val(cityname);
                                var iscity = false;
                                $("#" + cityid + " option").each(function () {
                                    if ($(this).text() == cityname) {
                                        cityvalue = $(this).val();
                                        $(this).attr("selected", true);
                                        iscity = true;
                                        return false;
                                    }
                                });
                                if (!iscity) {
                                    $("#" + cityid).prepend("<option value=" + cityname + ">" + cityname + "</option>");
                                    $("#" + cityid + " option:first").attr("selected", true);

                                    $("#" + areaid).prepend("<option value=" + areaname + ">" + areaname + "</option>");
                                    $("#" + areaid + " option:first").attr("selected", true);

                                } else {
                                    areaFunc(Obj, cityvalue, function () {
                                        //$areaid.val(areaname);
                                        var isarea = false;
                                        $("#" + areaid + " option").each(function () {
                                            if ($(this).text() == areaname) {
                                                $(this).attr("selected", true);
                                                isarea = true;
                                                return false;
                                            }
                                        });
                                        if (!isarea) {
                                            $("#" + areaid).prepend("<option value=" + areaname + ">" + areaname + "</option>");
                                            $("#" + areaid + " option:first").attr("selected", true);
                                        }
                                    });
                                }
                            });
                        }
                    }
                }
            });
        },
        initialize_val: function (provincevalue, cityvalue, areavalue) {
            var jsonObj = new Object();
            jsonObj.rootID = 0;
            $.ajax({
                type: "post",
                url: "/Common/GetAreaList",
                global: false,
                dataType: "json",
                data: JSON.stringify(jsonObj),
                contentType: "application/json; charset=utf-8",
                success: function (context) {
                    $provinceid.empty().append('<option value="">-省份-</option>');
                    $.each(context.Data, function () {
                        $provinceid.append('<option value="' + this.Value + '">' + this.Text + '</option>');
                    });
                    if (!provincevalue) {//表示默认选中
                        $cityid.empty().append('<option value="">-城市-</option>');
                        $areaid.empty().append('<option value="">-县区-</option>');
                    } else {
                        $provinceid.val(provincevalue);
                        cityFunc(Obj,provincevalue, function () {
                            $cityid.val(cityvalue);
                            areaFunc(Obj,cityvalue, function () {
                                $areaid.val(areavalue);
                            });
                        });
                    }
                }
            });
        }
    }
}