﻿; (function ($) {
    jQuery.weixin = {
        initialize: function (appId, timestamp, nonceStr, signature,callback) {
            wx.config({
                //debug: true,
                appId: appId,
                timestamp: timestamp,
                nonceStr: nonceStr,
                signature: signature,
                jsApiList: [
                  'checkJsApi',
                  'onMenuShareTimeline',
                  'onMenuShareAppMessage',
                  'onMenuShareQQ',
                  'onMenuShareWeibo',
                  'hideMenuItems',
                  'showMenuItems',
                  'hideAllNonBaseMenuItem',
                  'showAllNonBaseMenuItem',
                  'translateVoice',
                  'startRecord',
                  'stopRecord',
                  'onRecordEnd',
                  'playVoice',
                  'pauseVoice',
                  'stopVoice',
                  'uploadVoice',
                  'downloadVoice',
                  'chooseImage',
                  'previewImage',
                  'uploadImage',
                  'downloadImage',
                  'getNetworkType',
                  'openLocation',
                  'getLocation',
                  'hideOptionMenu',
                  'showOptionMenu',
                  'closeWindow',
                  'scanQRCode',
                  'chooseWXPay',
                  'openProductSpecificView',
                  'addCard',
                  'chooseCard',
                  'openCard'
                ]
            });
            wx.ready(function () {
                callback();
            });
            wx.error(function (res) {
                // config信息验证失败会执行error函数，如签名过期导致验证失败，具体错误信息可以打开config的debug模式查看，
                //也可以在返回的res参数中查看，对于SPA可以在这里更新签名。
                //alert("error:" + res.errMsg);
            });
        },
        share: function (title,link,desc,imgUrl) {
            wx.ready(function () {
                wx.onMenuShareTimeline({
                    title: title, // 分享标题
                    desc: desc,
                    link: link,
                    imgUrl: imgUrl, // 分享图标
                    //trigger: function (res) {
                    //    alert('用户点击分享到朋友圈');
                    //},
                    success: function (res) {
                        //$(".wxshare_btnCancel").click();
                        alert("分享成功1");
                    }
                });

                wx.onMenuShareAppMessage({
                    title: title, // 分享标题
                    desc: desc,
                    link: link,
                    imgUrl: imgUrl,
                    //trigger: function (res) {
                    //    alert('用户点击发送给朋友');
                    //},
                    success: function (res) {
                        //$(".wxshare_btnCancel").click();
                        alert("分享成功2");
                    }
                });
                wx.onMenuShareTimeline({
                    title: title, // 分享标题
                    desc: desc,
                    link: link,
                    imgUrl: imgUrl,
                    //trigger: function (res) {
                    //    alert('用户点击分享到朋友圈');
                    //},
                    success: function (res) {
                        //$(".wxshare_btnCancel").click();
                        alert("分享成功3");
                    }
                });
                wx.onMenuShareQQ({
                    title: title, // 分享标题
                    desc: desc,
                    link: link,
                    imgUrl: imgUrl,
                    //trigger: function (res) {
                    //    alert('用户点击分享到QQ');
                    //},
                    success: function (res) {
                        alert("分享成功4");
                    }
                });
                wx.onMenuShareWeibo({
                    title: title, // 分享标题
                    desc: desc,
                    link: link,
                    imgUrl: imgUrl,
                    //trigger: function (res) {
                    //    alert('用户点击分享到微博');
                    //},
                    success: function (res) {
                        alert("分享成功5");
                    }
                });
            });
        }
    };
})(jQuery);