﻿/// <reference path="../jquery-1.5.1-vsdoc.js" />
$(function () {
    $("#catalog").accordion();
    $("#catalog h6").draggable({
        cursor: 'move',
        revert: "invalid",
        appendTo: "parent",
        helper: "clone",
        revertDuration: 500,
        cancel: ".zhezhaoIn",
        addClasses: false,
        connectToSortable: "#cart ol",
    });
    $("#cart ol").droppable({
        activeClass: "ui-state-default",
        hoverClass: "state-hover",
        accept: ":not(.ui-sortable-helper)", /*还原*/

        drop: function (event, ui) {
            if ($("#cart ol .inin").first().length <= 0) return;

            var json = new Object();
            json.PageID = newGuid();
            json.Type = $(ui.draggable.context).attr("type");
            json.IsShow = true;
            //$("<h6 class='mid_li_controls' onclick='midControl(event)' submit='0' type='" + json.Type + "' data-id='" + json.PageID + "' id='component_" + json.PageID + "' style='background:#a9a9a9'></h6>").html($('.ui-widget-content ol h6').html()).appendTo(this);

            $("#cart ol .inin").first().parent().attr("data-id", json.PageID);
            $("#cart ol .inin").first().parent().attr("id", "component_" + json.PageID);

            $("#cart ol .inin").remove();
            $("#cart ol .catalogIn").css("display", "block");

            layer.load();
            $.ajax({
                url: "/divshop/page/settingpage",
                data: { type: json.Type, json: JSON.stringify(json) },
                type: "post",
                success: function (context) {
                    layer.closeAll();
                    $(".mainRight li").hide();
                    $(".mainRight").append(context);
                },
                error: function () { layer.closeAll(); }
            });

            // hover事件
            $(".phoneIn").hover(function (event) {
                $(this).children('.phoneIn-del').stop().animate({ "top": "0" }, 100);
                $(this).css("border", "1px dashed blue");

            }, function () {
                $(".phoneIn").children('.phoneIn-del').stop().animate({ "top": "-32px" }, 100);
                $(this).css("border", "none")

            });

            $(".touming").click(function (event) {
                $(".zhezhao").hide();
                $(".zhezhaoIn").stop().animate({ "top": "-180px" }, 300);

                $("#setting_" + $(this).parent().attr("data-id")).remove();
                $(this).parent().remove();
                $(this).remove();

                if ($(".mainRight li").length <= 1) {
                    $(".mainRight-in").show();
                }
                else {
                    $(".mainRight li:eq(1)").show();
                }
            });

            // 点击弹出框
            $(".phoneIn-del .del-one").click(function (event) {

                $(".zhezhao").show();
                $(".zhezhaoIn").show().stop().animate({ "top": "40" }, 500);
                $(this).parents(".phoneIn").siblings(".touming").show();
            });
            $(".btn-two").click(function (event) {

                $(".zhezhao").hide();
                $(".zhezhaoIn").stop().animate({ "top": "-180px" }, 300);

            });
            $(".phoneIn-del .del-two").click(function (event) {

                $(".mainRight-inther").show();
                $(".mainRight-in").hide();
            });
        }
    }).sortable({
        axis: 'y',
        opacity: 0.5,
        placeholder: "ui-state-highlight",
        sort: function () {
            // 获取   由 droppable 与 sortable 交互而加入的条目
            // 使用 connectWithSortable 可以解决这个问题，但不允许您自定义 active/hoverClass 选项
            $(this).removeClass("ui-state-default");
        }
    });

    initialization();
});
//中间控件点击事件
function midControl(event) {
    event = event ? event : window.event;
    var obj = event.srcElement ? event.srcElement : event.target;

    if (!$(obj).hasClass("mid_li_controls")) {
        obj = $(obj).parents(".mid_li_controls:first");
    }

    //处理点击事件
    $(".mainRight-in").hide();
    $(".mainRight li").hide();
    $("#setting_" + $(obj).attr("data-id")).show();
}
//提交设置
function submitSetting(id, type) {

    var json = getPageSetting(id, type);

    if (!checkPageSetting(id, type, json)) { return false; }

    layer.load();

    $.ajax({
        url: "/divshop/page/component",
        data: { type: json.Type, json: JSON.stringify(json) },
        type: "post",
        success: function (context) {
            layer.closeAll();

            var pageId = "#component_" + id;

            var attr = getAttributes(id, type);

            $(pageId).attr("submit", "1");
            $(pageId).find(".phoneIn").css("background", "none");
            $(pageId).attr("json", JSON.stringify(attr));
            $(pageId).find(".phoneIn").children(".components").empty();
            $(pageId).find(".phoneIn").children(".components").html(context);
        },
        error: function () { layer.closeAll(); }
    });
}

//获取配置参数
function getAttributes(id, type) {

    var json = getPageSetting(id, type);

    var attr = new Object();
    attr.WinportMainGuid = id;
    attr.PropertyJson = JSON.stringify(json);

    return attr;
}

function getPageSetting(id, type) {
    if (type == 1) {
        var json = new Object();
        json.PageID = id;
        json.Type = type;
        json.CssValue = $("input[name='lunbos_" + id + "']:checked").val();
        json.Title = $("#title_" + id).val();
        json.TitleColor = $("#title_color_" + id).val();
        json.BackgroundColor = $("#background_color_" + id).val();
        json.Link = $("#title_bar_link_" + id).val();
        json.IsShowBottom = $("#is_show_bottom_" + id).attr("checked") == "checked" ? true : false;

        return json;
    }
    else if (type == 2) {
        var json = new Object();
        json.PageID = id;
        json.Type = type;
        json.CssValue = $("input[name='lunbos_" + id + "']:checked").val();
        json.StoreTitle = $("#store_title_" + id).val();
        json.StoreColor = $("#store_color_" + id).val();
        json.BackgroundColor = $("#background_color_" + id).val();
        if ($("#head_store_imgage_" + id).attr("src") != "/Content/DIVShop/img/pic.png") {
            json.StoreImgage = $("#head_store_imgage_" + id).attr("src");
        }
        json.BorderRadius = $("#head_border_radius_" + id).val();
        json.IsShowBottom = $("#is_show_bottom_" + id).attr("checked") == "checked" ? true : false;
        return json;
    }
    else if (type == 3) {
        var json = new Object();
        json.PageID = id;
        json.Type = type;
        json.CssValue = $("input[name='lunbos_" + id + "']:checked").val();
        json.InterTime = $("#slider_inter_time_" + id).val();
        json.IsShowBottom = $("#is_show_bottom_" + id).attr("checked") == "checked" ? true : false;

        var images = new Array();

        $("#image_list_" + id).children(".lunbo-section-in").each(function (i, item) {
            var img = new Object();
            img.ImageUrl = $(this).children(".lunbo-section-in-img").children("img").attr("src");
            img.Link = $(this).children(".lunbo-section-in-src").children("input").val();

            if (img.ImageUrl == "/Content/DIVShop/img/pic.png") return true;

            images.push(img);
        });
        json.Images = images;

        return json;
    }
    else if (type == 4) {
        var json = new Object();
        json.PageID = id;
        json.Type = type;
        json.CssValue = $("input[name='lunbos_" + id + "']:checked").val();
        json.IsShowBottom = $("#is_show_bottom_" + id).attr("checked") == "checked" ? true : false;

        var images = new Array();

        $("#image_list_" + id).find(".figure-section-in").each(function (i, item) {
            var img = new Object();
            img.ImageUrl = $(this).children(".figure-section-in-img").children("img").attr("src");
            img.Link = $(this).children(".figure-section-in-src").children("input").val();

            if (img.ImageUrl == "/Content/DIVShop/img/pic.png") return true;

            images.push(img);

            if (json.CssValue == 1 && images.length >= 1) return false;

            else if (json.CssValue == 2 && images.length >= 2) return false;

            else if (json.CssValue == 3 && images.length >= 3) return false;

            else if (json.CssValue == 4 && images.length >= 3) return false;

            else if (json.CssValue == 5 && images.length >= 3) return false;

            else if (json.CssValue == 6 && images.length >= 4) return false;

            else if (json.CssValue == 7 && images.length >= 4) return false;
        });
        json.Images = images;

        return json;
    }
    else if (type == 5) {
        var json = new Object();
        json.PageID = id;
        json.Type = type;
        json.CssValue = $("input[name='lunbos_" + id + "']:checked").val();
        json.ProductCategoryGuid = $("#goods_category_" + id).val();
        json.CategoryName = $("#goods_category_" + id).find("option:selected").text();
        json.Filter = $("#goods_filter_" + id).val();
        json.ProductNum = $("#goods_product_num_" + id).val();
        json.IsShowCategory = $("input[name='is_show_category_" + id + "']:checked").val() == "1" ? true : false;
        json.IsShowBottom = $("#is_show_bottom_" + id).attr("checked") == "checked" ? true : false;

        return json;
    }
    else if (type == 6) {
        var json = new Object();
        json.PageID = id;
        json.Type = type;
        json.IsShowBottom = $("#is_show_bottom_" + id).attr("checked") == "checked" ? true : false;
        json.PreviewUrl = $("#setting_" + id + " > .mainRight-video-main > .lunbo-section .lunbo-section-in-img > img").attr("src");
        json.VideoUrl = $("#setting_" + id + " > .mainRight-video-main > .lunbo-section .lunbo-section-in-video > label > .path").text();

        return json;
    }
    else if (type == 7) {
        var json = new Object();
        json.PageID = id;
        json.Type = type;
        json.IsShowBottom = $("#is_show_bottom_" + id).attr("checked") == "checked" ? true : false;
        json.CssValue = $("input[name='lunbos_" + id + "']:checked").val();
        json.FontColor = $("#font_color_" + id).val();
        json.ButtonColor = $("#button_color_" + id).val();
        json.PresetKeyword = $("#preset_keyword_" + id).val();

        return json;
    }
    else if (type == 8) {
        var json = new Object();
        json.PageID = id;
        json.Type = type;
        json.IsShowBottom = $("#notice_is_show_bottom_" + id).attr("checked") == "checked" ? true : false;
        json.FontColor = $("#notice_font_color_" + id).val();
        json.BackgroundColor = $("#notice_background_color_" + id).val();
        json.IconColor = $("#notice_icon_color_" + id).val();

        return json;
    }
}

function checkPageSetting(id, type, json) {

    if (json == null || json == undefined) {
        layer.alert("保存对象不能为空！", { icon: 2 });
        return false;
    }

    if (type == 1) {
        if (json.Title == '') {
            layer.tips("标题不能为空！", "#title_" + id);
            return false;
        }
    }
    else if (type == 2) {
        if (json.Title == '') {
            layer.tips("店铺名称不能为空！", "#store_title_" + id);
            return false;
        }
    }
    else if (type == 3) {
        if (json.Images == null || json.Images == undefined || json.Images.length <= 0) {
            layer.tips("至少上传一张图片！", "#setting_" + id + " .lunbo-section .lunbo-btn .lunbo-btn-next");
            return false;
        }
    }
    else if (type == 4) {

        if (json.CssValue == 1 && json.Images.length <= 0) {
            layer.tips("单图导航至少上传一张图片！", "#image_list_" + id + " .figure-section-in-img:eq(0) img");
            return false;
        }
        if (json.CssValue == 2 && json.Images.length <= 1) {
            layer.tips("双图导航至少上传两张图片！", "#image_list_" + id + " .figure-section-in-img img[src='/Content/DIVShop/img/pic.png']:first");
            return false;
        }
        if (json.CssValue == 3 && json.Images.length <= 2) {
            layer.tips("三图导航1至少上传三张图片！", "#image_list_" + id + " .figure-section-in-img img[src='/Content/DIVShop/img/pic.png']:first");
            return false;
        }
        if (json.CssValue == 4 && json.Images.length <= 2) {
            layer.tips("三图导航2至少上传三张图片！", "#image_list_" + id + " .figure-section-in-img img[src='/Content/DIVShop/img/pic.png']:first");
            return false;
        }
        if (json.CssValue == 5 && json.Images.length <= 2) {
            layer.tips("三图导航3至少上传三张图片！", "#image_list_" + id + " .figure-section-in-img img[src='/Content/DIVShop/img/pic.png']:first");
            return false;
        }
        if (json.CssValue == 6 && json.Images.length <= 3) {
            layer.tips("四图导航1至少上传四张图片！", "#image_list_" + id + " .figure-section-in-img img[src='/Content/DIVShop/img/pic.png']:first");
            return false;
        }
        if (json.CssValue == 7 && json.Images.length <= 3) {
            layer.tips("四图导航2至少上传四张图片！", "#image_list_" + id + " .figure-section-in-img img[src='/Content/DIVShop/img/pic.png']:first");
            return false;
        }
    }
    else if (type == 5) {
        return true;
    }
    else if (type == 6) {
        if (json.PreviewUrl == '' || json.PreviewUrl == '/Content/DIVShop/img/pic.png') {
            layer.tips("预览图片不能为空，请上传预览图片！", "#setting_" + id + " > .mainRight-video-main > .lunbo-section .lunbo-section-in-img > img");
            return false;
        }

        if (json.VideoUrl == '') {
            layer.tips("视频不能为空，请上传视频！", "#setting_" + id + " > .mainRight-video-main > .lunbo-section .lunbo-section-in-video > label");
            return false;
        }
    }
    else if (type == 7) {
        if (json.PresetKeyword != '' && json.PresetKeyword.length > 7) {
            layer.tips("预设关键字不能大于7！", "#preset_keyword_" + id);
            return false;
        }
    }
    else if (type == 8) {
        return true;
    }

    return true;
}

function newGuid() {
    var guid = "";
    for (var i = 1; i <= 32; i++) {
        var n = Math.floor(Math.random() * 16.0).toString(16);
        guid += n;
        if ((i == 8) || (i == 12) || (i == 16) || (i == 20))
            guid += "-";
    }
    return guid;
}

//-------添加轮播图图片    Start-------
function addImage(event) {
    event = event ? event : window.event;
    var obj = event.srcElement ? event.srcElement : event.target;

    var html = '<div class="lunbo-section-in"><div class="lunbo-section-in-img"><img src="/Content/DIVShop/img/pic.png" alt="" />';
    html += '<div class="lunbo-section-in-btn"><div class="lunbo-btn"><button class="lunbo-btn-next" onclick="openSystemIamge(event)">选择图片</button>&nbsp;<button class="lunbo-btn-next" onclick="uploadImage(event)">上传图片</button>&nbsp;<button onclick="deleteImage(event)" class="lunbo-btn-next">删除图片</button></div></div></div>';
    html += '<div class="lunbo-section-in-src"><i>图片链接</i><input type="text" /><button class="btn-link" onclick="opentSystemLink(event)">选择</button></div></div>';

    $(obj).parent().parent().prev().append(html);
}

function deleteImage(event) {
    event = event ? event : window.event;
    var obj = event.srcElement ? event.srcElement : event.target;

    layer.load();
    $.ajax({
        url: "/divshop/main/DeleteImage",
        data: { path: $(obj).parent().parent().prev().attr("src") },
        type: "post",
        success: function (context) {
            layer.closeAll();
            if (context.Result == "OK") {
                $(obj).parents(".lunbo-section-in:first").remove();
            }
            else {
                layer.alert(context.Msg, { icon: 2 });
            }
        },
        error: function () { layer.closeAll(); }
    });

}

function removeImage(event) {
    event = event ? event : window.event;
    var obj = event.srcElement ? event.srcElement : event.target;

    layer.load();
    $.ajax({
        url: "/divshop/main/DeleteImage",
        data: { path: $(obj).parents("div:eq(2)").children("img").attr("src") },
        type: "post",
        success: function (context) {
            layer.closeAll();
            if (context.Result == "OK") {
                $(obj).parents("div:eq(2)").children("img").attr("src", "/Content/DIVShop/img/pic.png");;
            }
            else {
                layer.alert(context.Msg, { icon: 2 });
            }
        },
        error: function () { layer.closeAll(); }
    });
}

var currentUploadBtn = null;
function uploadImage(event) {
    event = event ? event : window.event;
    var obj = event.srcElement ? event.srcElement : event.target;

    currentUploadBtn = obj;

    $("#filechoice").click();
}
//-------添加轮播图图片    End-------

//-------上传视频   start--------
function uploadVideo(event) {
    event = event ? event : window.event;
    var obj = event.srcElement ? event.srcElement : event.target;

    currentUploadBtn = obj;

    $("#filechoiceVideo").click();
}

function deleteVideo(event) {
    event = event ? event : window.event;
    var obj = event.srcElement ? event.srcElement : event.target;

    layer.load();
    $.ajax({
        url: "/divshop/main/DeleteVideo",
        data: { path: $(obj).parents("div:eq(2)").find(".path:first").text() },
        type: "post",
        success: function (context) {
            layer.closeAll();
            if (context.Result == "OK") {
                $(obj).parents("div:eq(2)").prev().text("未上传视频");
                $(obj).parents("div:eq(2)").find(".path:first").text("");
            }
            else {
                layer.alert(context.Msg, { icon: 2 });
            }
        },
        error: function () { layer.closeAll(); }
    });

    $(obj).parents("div:eq(2)").prev().text("未上传视频");
    $(obj).parents("div:eq(2)").find(".path:first").text("");

}
//-------上传视频   end----------

//-------选择系统链接   start-------
function opentSystemLink(event) {
    event = event ? event : window.event;
    var obj = event.srcElement ? event.srcElement : event.target;

    currentUploadBtn = obj;

    $("#layui-layer-shade-link").show();
    $("#layui-layer-tab-link").show();
}

function openSystemIamge(event) {
    event = event ? event : window.event;
    var obj = event.srcElement ? event.srcElement : event.target;

    currentUploadBtn = obj;

    $("#layui-layer-shade-link").show();
    $("#layui-layer-tab-images").show();
}

function closeSystemLink() {
    $("#layui-layer-shade-link").hide();
    $("#layui-layer-tab-link").hide();
    $("#layui-layer-tab-images").hide();
}

function selectLink(event) {
    event = event ? event : window.event;
    var obj = event.srcElement ? event.srcElement : event.target;

    var url = $.trim($(obj).parent().prev().text());

    if (url == '') {
        url = $.trim($(obj).parent().parent().prev().text());
    }
    $(currentUploadBtn).prev().val(url);

    closeSystemLink();
}

function selectImageLink(event) {
    event = event ? event : window.event;
    var obj = event.srcElement ? event.srcElement : event.target;

    var url = $.trim($(obj).parent().prev().text());

    if (url == '') {
        url = $.trim($(obj).parent().parent().prev().text());
    }

    var imageUrl = $(obj).parents("tr:first").children("td:first").children("img").attr("src");

    $(currentUploadBtn).parents("div:eq(2)").next().children("input:first").val(url);
    $(currentUploadBtn).parent().parent().prev().attr("src", imageUrl);

    closeSystemLink();
}
//-------选择系统链接   end---------
//-------初始化    start-----------
function initialization() {
    $("#layui-layer-tab-link > .layui-layer-title > span").click(function () {
        $("#layui-layer-tab-link > .layui-layer-title > span.layui-layer-tabnow").removeClass("layui-layer-tabnow");
        $(this).addClass("layui-layer-tabnow");

        $("#layui-layer-tab-link > .layui-layer-content > ul > li:visible").hide();
        $("#layui-layer-tab-link > .layui-layer-content > ul > li:eq(" + $(this).index() + ")").css("display", "list-item");
    });
}
//-------初始化    end-------------