﻿; (function ($) {

    var imgUploadDefaults = {
        height: 100, //宽度和高度可以通过img 的宽度和高度属性,设置优先
        width: 100,
        url: "",
        data:null,
        defaultImg: ""//默认图片
    }

    $.extend($.fn, {
        imgUpload: function (options) {
            var $this = $(this);
            $this.attr("cursor","pointer");
            $this.data("options", options);

            if (options) {
                $this.width(options.width || $this.width || imgUploadDefaults.width);
                $this.height(options.height || $this.height || imgUploadDefaults.height);
                if (options.defaultImg) {
                    $this.attr("src", options.defaultImg);
                }
            }

            var filedivname  = "imgfileupload_" + $this.attr("id");


            var $fileWrap;
            if ($("#" + filedivname).length > 0) {
                $fileWrap = $("#" + filedivname);
            }
            else {
                $fileWrap = $('<div style="height:0px; width:0px; overflow:hidden; font-size:0px;"><input type="file" id="' + filedivname + '" name="' + filedivname + '"  multiple accept="image/*"  onchange="handleFiles(this)"></div>');
                $this.after($fileWrap);
            }

            $fileWrap.find("input[type=file]").data('imgObj', $this[0]);

            $this.click(function () {
                $fileWrap.find("input[type=file]").click();
                
            });

        },
        getImgUploadUrl:function(){
            return $(this).attr("src") || false;
        },
        setImgUploadParam: function (obj) {
            var imgOptions = $(this).data("options");
            var settings = $.extend({}, imgOptions, obj);
            $(this).imgUpload(settings);
        }


    });
})(jQuery);

function handleFiles(obj) {

    var files = obj.files;
    var img = $(obj).data("imgObj");
    var imgOptions = $(img).data("options");
    var imgupfile = $(obj);
    if (!imgupfile.val()) {
        return false;
    }

    if (!checkImgType(imgupfile.val())) {
        alert("格式不正确,只能上传格式为gif|jpeg|jpg|png|bmp！");
        return false;
    }

    var span = imgupfile.parent();

    var myform = document.createElement("form");
    myform.action = imgOptions.url;
    myform.method = "post";
    myform.enctype = "multipart/form-data";
    myform.style.display = "none";

    //将表单加当document上，
    document.body.appendChild(myform);  //创建表单后一定要加上这句否则得到的form不能上传。document后要加上body,否则火狐下不行。


    var form = $(myform);

    if (imgOptions.data) {
        var data = imgOptions.data;
        for (var key in data) {
            form.append('<input type="hidden"  value="' + data[key] + '" name="' + key + '" id="' + key + '" />');
        }

        
    }

    var bakimgupfile = imgupfile.clone(true).val("");
    imgupfile.appendTo(form);

    form.ajaxSubmit({
        beforeSubmit: function () {
            if (imgOptions.before) {
                imgOptions.before();
            }
        },
        success: function (data) {

            if (data == "NoFile" || data == "Error" || data == "格式不正确！") {
                alert(data);
            }
            else {

                var myimg = $(img);
                myimg.attr("src", data); //给img赋值。
                if (imgOptions || imgOptions.callback) {
                    imgOptions.callback(data);
                }
            }
            span.append(bakimgupfile);
            form.remove();
        }
    });

    //HTML5
    //window.URL = window.URL || window.webkitURL;

    //if (window.URL) {
    //    //File API
    //    //alert(files[0].name + "," + files[0].size + " bytes");
    //    img.src = window.URL.createObjectURL(files[0]); //创建一个object URL，并不是你的本地路径
    //    img.onload = function (e) {
    //        window.URL.revokeObjectURL(this.src); //图片加载后，释放object URL
    //    }
    //} else if (window.FileReader) {
    //    //opera不支持createObjectURL/revokeObjectURL方法。我们用FileReader对象来处理
    //    var reader = new FileReader();
    //    reader.readAsDataURL(files[0]);
    //    reader.onload = function (e) {
    //        alert(files[0].name + "," + e.total + " bytes");
    //        img.src = this.result;
    //    }
    //} else {
    //    //ie
    //    obj.select();
    //    obj.blur();
    //    var nfile = document.selection.createRange().text;
    //    document.selection.empty();
    //    img.src = nfile;
    //    img.onload = function () {
    //        alert(nfile + "," + img.fileSize + " bytes");
    //    }
    //    //fileList.style.filter="progid:DXImageTransform.Microsoft.AlphaImageLoader(sizingMethod='image',src='"+nfile+"')";
    //}
}

//检查上传的图片格式
function checkImgType(filename) {
    var pos = filename.lastIndexOf(".");
    var str = filename.substring(pos, filename.length)
    var str1 = str.toLowerCase();
    if (!/\.(gif|jpg|jpeg|png|bmp)$/.test(str1)) {
        return false;
    }
    return true;
}