﻿//中文提示信息拓展
jQuery.extend(jQuery.validator.messages, {
    required: "必填字段",
    remote: "请修正该字段",
    email: "请输入正确格式的电子邮件",
    url: "请输入合法的网址",
    date: "请输入合法的日期",
    dateISO: "请输入合法的日期 (ISO).",
    number: "请输入合法的数字",
    digits: "只能输入整数",
    creditcard: "请输入合法的信用卡号",
    equalTo: "请再次输入相同的值",
    accept: "请输入拥有合法后缀名的字符串",
    maxlength: jQuery.validator.format("请输入一个长度最多是 {0} 的字符串"),
    minlength: jQuery.validator.format("请输入一个长度最少是 {0} 的字符串"),
    rangelength: jQuery.validator.format("请输入一个长度介于 {0} 和 {1} 之间的字符串"),
    range: jQuery.validator.format("请输入一个介于 {0} 和 {1} 之间的值"),
    max: jQuery.validator.format("请输入一个最大为 {0} 的值"),
    min: jQuery.validator.format("请输入一个最小为 {0} 的值")
});


////set the validator defaults
//$.validator.setDefaults({ success: "success" }); //自定义验证结果样式

// 数字验证       
jQuery.validator.addMethod("digital", function (value, element) {
    return this.optional(element) || /^[0-9]*$/.test(value);
}, "只能输入数字");

// 字符验证       
jQuery.validator.addMethod("stringCheck", function (value, element) {
    return this.optional(element) || /^[\u0391-\uFFE5\w]+$/.test(value);
}, "只能包括中文字、英文字母、数字和下划线");

//英文字母，可以大写或小写
jQuery.validator.addMethod("eng", function (value, element) {
    value = $.trim(value);
    return this.optional(element) || /^([A-Za-z]+\s?)*[A-Za-z]$/.test(value);//^[A-Za-z]+$/
}, "只能输入英文");

//必须包含至少一位数字，一位大写字母，一位小写字母
jQuery.validator.addMethod("pwda", function (value, element) {
    value = $.trim(value);
    return this.optional(element) || (value.match(/([a-z])+/) && value.match(/([0-9])+/) && value.match(/([A-Z])+/));
}, "必须由大小写字母和数字组成");

//必须包含至少一位数字，一位大写字母，一位小写字母 一位特殊字符
jQuery.validator.addMethod("pwdb", function (value, element) {
    value = $.trim(value);
    return this.optional(element) || (value.match(/([a-z])+/) && value.match(/([0-9])+/) && value.match(/([A-Z])+/) && value.match(/[^a-zA-Z0-9]+/));
}, "必须由大小写字母,数字和特殊字符组成");

// 英文字母、数字和下划线 字符验证       
jQuery.validator.addMethod("ENUCheck", function (value, element) {
    return this.optional(element) || /\w/.test(value);
}, "只能包括英文字母、数字和下划线");

// 金额money  （正数或正小数）
jQuery.validator.addMethod("money", function (value, element) {
    return this.optional(element) || /^[+]?[\d]+(([\.]{1}[\d]+)|([\d]*))$/.test(value);
}, "请填写格式正确的金额,大于零的整数或小数");

// 次数times （正整数）
jQuery.validator.addMethod("times", function (value, element) {
    return this.optional(element) || /^[0-9]*[1-9][0-9]*$/.test(value);
}, "请填写整数");


// 身份证号码验证
jQuery.validator.addMethod("isIdCardNo", function (value, element) {
    return this.optional(element) || isIdCardNo(value);
}, "请正确输入您的身份证号码");

// 手机号码验证
jQuery.validator.addMethod("isMobile", function (value, element) {
    var length = value.length;
    var YDmobile = /^1(3[4-9]|5[012789]|8[78])\d{8}$/; //移动
    var LTmobile = /^18[09]\d{8}$/;//联通
    var DXmobile = /^1(3[0-2]|5[56]|8[56])\d{8}$/;//电信
    return this.optional(element) || (length == 11 && (YDmobile.test(value) || LTmobile.test(value) || DXmobile.test(value)));
}, "请正确填写您的手机号码");

// 电话号码验证       
jQuery.validator.addMethod("isTel", function (value, element) {
    var tel = /^\d{3,4}-?\d{7,9}$/;    //电话号码格式010-12345678   
    return this.optional(element) || (tel.test(value));
}, "请正确填写您的电话号码");

// 联系电话(手机/电话皆可)验证   
jQuery.validator.addMethod("isPhone", function (value, element) {
    var length = value.length;
    var YDmobile = /^1(3[4-9]|5[012789]|8[78])\d{8}$/; //移动
    var LTmobile = /^18[09]\d{8}$/;//联通
    var DXmobile = /^1(3[0-2]|5[56]|8[56])\d{8}$/;//电信
    var tel = /^\d{3,4}-?\d{7,9}$/;
    return this.optional(element) || (tel.test(value) || (YDmobile.test(value) || LTmobile.test(value) || DXmobile.test(value)));

}, "请正确填写您的联系电话");

// 邮政编码验证       
jQuery.validator.addMethod("isZipCode", function (value, element) {
    var tel = /^[0-9]{6}$/;
    return this.optional(element) || (tel.test(value));
}, "请正确填写您的邮政编码");


// 字数限制 中文字两个字节       
jQuery.validator.addMethod("byteRangeLength", function (value, element, param) {
    var length = value.length;
    for (var i = 0; i < value.length; i++) {
        if (value.charCodeAt(i) > 127) {
            length++;
        }
    }
    return this.optional(element) || (length >= param[0] && length <= param[1]);
}, "请确保输入的值在3-15个字节之间(一个中文字算2个字节)");

function isIdCardNo(idcard, bit) {
    var area = {
        11: "北京",
        12: "天津",
        13: "河北",
        14: "山西",
        15: "内蒙古",
        21: "辽宁",
        22: "吉林",
        23: "黑龙江",
        31: "上海",
        32: "江苏",
        33: "浙江",
        34: "安徽",
        35: "福建",
        36: "江西",
        37: "山东",
        41: "河南",
        42: "湖北",
        43: "湖南",
        44: "广东",
        45: "广西",
        46: "海南",
        50: "重庆",
        51: "四川",
        52: "贵州",
        53: "云南",
        54: "西藏",
        61: "陕西",
        62: "甘肃",
        63: "青海",
        64: "宁夏",
        65: "新疆",
        71: "台湾",
        81: "香港",
        82: "澳门",
        91: "国外"
    };
    var retflag=false;
    var Y,JYM,ereg;
    var S,M;
    var idcard_array = new Array();
    idcard_array = idcard.split("");
    //地区检验
    if (area[parseInt(idcard.substr(0, 2))] == null) return false;
    //身份号码位数及格式检验
    switch(idcard.length){
        case 15:
            if ( (parseInt(idcard.substr(6,2))+1900) % 4 == 0 || ((parseInt(idcard.substr(6,2))+1900) % 
            100 == 0 && (parseInt(idcard.substr(6,2))+1900) % 4 == 0 )){
            var ereg=/^[1-9][0-9]{5}[0-9]{2}((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|[1-2][0-9]))[0-9]{3}$/;//测试出生日期的合法性
            } else {
            var ereg=/^[1-9][0-9]{5}[0-9]{2}((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|1[0-9]|2[0-8]))[0-9]{3}$/;//测试出生日期的合法性
            }
        if (ereg.test(idcard))
                return true;
            else 
            {
                return false;
            }
            break;
        case 18:
            //18位身份号码检测
            //出生日期的合法性检查 
            //闰年月日:((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|[1-2][0-9]))
            //平年月日:((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|1[0-9]|2[0-8]))
            if ( parseInt(idcard.substr(6,4)) % 4 == 0 || (parseInt(idcard.substr(6,4)) % 100 == 0 && 
            parseInt(idcard.substr(6,4))%4 == 0 )){
            ereg=/^[1-9][0-9]{5}19[0-9]{2}((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|[1-2][0-9]))[0-9]{3}[0-9Xx]$/;//闰年出生日期的合法性正则表达式
            } else {
            ereg=/^[1-9][0-9]{5}19[0-9]{2}((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|1[0-9]|2[0-8]))[0-9]{3}[0-9Xx]$/;//平年出生日期的合法性正则表达式
            }

            if(ereg.test(idcard)){//测试出生日期的合法性
                //计算校验位
                S = (parseInt(idcard_array[0]) + parseInt(idcard_array[10])) * 7
                + (parseInt(idcard_array[1]) + parseInt(idcard_array[11])) * 9
                + (parseInt(idcard_array[2]) + parseInt(idcard_array[12])) * 10
                + (parseInt(idcard_array[3]) + parseInt(idcard_array[13])) * 5
                + (parseInt(idcard_array[4]) + parseInt(idcard_array[14])) * 8
                + (parseInt(idcard_array[5]) + parseInt(idcard_array[15])) * 4
                + (parseInt(idcard_array[6]) + parseInt(idcard_array[16])) * 2
                + parseInt(idcard_array[7]) * 1 
                + parseInt(idcard_array[8]) * 6
                + parseInt(idcard_array[9]) * 3 ;
                Y = S % 11;
                M = "F";
                JYM = "10X98765432";
                M = JYM.substr(Y,1);//判断校验位
                if (M == idcard_array[17]) return true; //检测ID的校验位
                else return false;
            }
            else return false;
            break;
        default:
            return false;
            break;
}
}

// 正则验证
jQuery.validator.addMethod("regular", function (value, element, param) {
    var reg = new RegExp(param);
    return this.optional(element) || reg.test(value);

}, "不符合指定格式！");

// 输入不相等的值
jQuery.validator.addMethod("notequalTo", function (value, element, param) {
    var target = $(param).unbind(".validate-notequalTo").bind("blur.validate-notequalTo", function () {
        $(element).valid();
    });
    return value != target.val();
}, "请输入不同的值！");

//birthday
jQuery.validator.addMethod("birthday", function (value, element) {
    var reg = new RegExp(/^(?:(?:1[6-9]|[2-9][0-9])[0-9]{2}([-])(?:(?:0?[1-9]|1[0-2])\1(?:0?[1-9]|1[0-9]|2[0-8])|(?:0?[13-9]|1[0-2])\1(?:29|30)|(?:0?[13578]|1[02])\1(?:31))|(?:(?:1[6-9]|[2-9][0-9])(?:0[48]|[2468][048]|[13579][26])|(?:16|[2468][048]|[3579][26])00)([-])0?2\2(?:29))$/);
    return this.optional(element) || reg.test(value);
}, "请输入正确的生日格式！");

function GetStringByteLength(val) {

    var Zhlength = 0;// 全角
    var Enlength = 0;// 半角

    for (var i = 0; i < val.length; i++) {
        if (val.substring(i, i + 1).match(/[^\x00-\xff]/ig) != null)
            Zhlength += 1;
        else
            Enlength += 1;
    }
    // 返回当前字符串字节长度
    return (Zhlength * 2) + Enlength;
}
