﻿using RFramework;
using RTCP;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Linq;
using System.ServiceProcess;
using System.Text;
using System.Threading.Tasks;
using System.Timers;

namespace jiouosdptask
{
    public partial class Service1 : ServiceBase
    {
        protected override void OnStart(string[] args)
        {
            Log.LogFolder = AppDomain.CurrentDomain.BaseDirectory + "\\log";

            try
            {
                RFrameGenerate.Common.DatabaseConfig.Database.InitConnection(System.Configuration.ConfigurationManager.ConnectionStrings["connectionString"].ToString());
            }
            catch (Exception ex)
            {
                Log.Write("启动读连接字符时失败:" + ex.Message);
            }
            Log.Write("OnStart");
            TaskManage.Start();
            //服务开启执行代码
        }
        protected override void OnStop()
        {
            Log.Write("OnStop");
            TaskManage.Disposable();
            OnStopManage.OnStop();
            //服务结束执行代码
        }
        protected override void OnPause()
        {
            Log.Write("OnPause");
            OnPauseManage.OnPause();
            //服务暂停执行代码
            base.OnPause();
        }
        protected override void OnContinue()
        {
            Log.Write("OnContinue");
            OnContinueManage.OnContinue();
            //服务恢复执行代码
            base.OnContinue();
        }
        protected override void OnShutdown()
        {
            Log.Write("OnShutdown");
            OnShutdownManage.OnShutdown();
            //系统即将关闭执行代码
            base.OnShutdown();
        }
    }
}
