﻿using jiouosdptask.BLL;
using jiouosdptask.Tasks;
using RFrameGenerate.BLL;
using RFramework;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace jiouosdptask
{
    public class TaskManage
    {
        public static List<TaskTimer> TTask = new List<TaskTimer>();
        public static void Disposable()
        {
            foreach (var v in TTask)
            {
                v.Dispose();
            }
            LotteryOpen.Stop();
        }
        /// <summary>
        /// 逻辑处理,间隔Interval
        /// </summary>
        public static void Start()
        {
            //逻辑处理 入口点

            TcpManage.Start();
            //订单
            TTask.Add(new TaskTimer("彩票出奖结果", 3 * 60 * 1000, (timer) => { LotteryResult.GetLottery(); }));
            TTask.Add(new TaskTimer("过期订单关闭", 5 * 60 * 1000, (timer) => { Order.orderCloseTime(); }));
            TTask.Add(new TaskTimer("确认收货", 5 * 60 * 1000, (timer) => { Order.orderCompleteTime(); }));
            TTask.Add(new TaskTimer("一元购订单", 5 * 60 * 1000, (timer) => { Order.corwdCompleteTime(); }));
            //贡献值
            TTask.Add(new TaskTimer("贡献值", 60 * 60 * 1000, (timer) => { Contribution.Run(); }));

            //一元购开奖
            LotteryOpen.Start();
            TTask.Add(new TaskTimer("一元购开奖,获取数据", 30 * 60 * 1000, (timer) => { LotteryOpen.InitPeriod(); }));

            //自动结算
            DateTime dt = DateTime.Now.Date.AddDays(1).AddSeconds(-1);
            int m = (int)(dt - DateTime.Now).TotalMinutes;
            TTask.Add(new TaskTimer("自动结算", m * 60 * 1000, (timer) =>
            {
                timer.Interval = 24 * 60 * 60 * 1000;
                var re = Order.certainTask();
                Log.Write(re.Msg);

                DistributionManage.ExtHqOrderPresentExp();

            }));


            #region 新旗舰版-定时任务 暂定 Bing 160422

            //新旗舰版-定时任务 暂定 Bing 160422
            DateTime dtSer = DateTime.Now.Date.AddDays(1).AddHours(3);
            int mSer = (int)(dtSer - DateTime.Now).TotalMinutes;
            TTask.Add(new TaskTimer("流水串行统计", mSer * 60 * 1000, (timer) =>
            {
                timer.Interval = 24 * 60 * 60 * 1000;

                var serNum = DateTime.Now.ToString("yyyyMMddHHmmss");
                Log.Write(string.Format("流水{0}串行统计开始", serNum));

                try
                {
                    AgentAccountManage.IsCountPrestore = true;
                    DistributionManage.CountAgentFactorage();
                }
                catch (Exception ex)
                {
                    Log.Write(string.Format("流水{0}串行统计_预存获取信息非法，无法统计", serNum));
                }
                finally
                {
                    AgentAccountManage.IsCountPrestore = false;
                }
                System.Threading.Thread.Sleep(1000 * 5);

                try
                {
                    AgentAccountManage.IsCountFsBalance = true;

                    DistributionManage.CountAgentProfit();
                    DistributionManage.CountAgentProfit_Inden();
                    DistributionManage.CountAgentSales();
                    DistributionManage.CountAgentCommission();
                }
                catch (Exception ex)
                {
                    Log.Write(string.Format("流水{0}串行统计_佣金/余额等操作失败", serNum));
                }
                finally
                {
                    AgentAccountManage.IsCountFsBalance = false;
                }

                Log.Write(string.Format("流水{0}串行统计完毕", serNum));
            }));

            #endregion

http://weixin.res.meizu.com/invitation_meilan3s/images/phone-call.png

            Log.Write("所有任务启动成功");

        }




    }
}
