﻿<%@ webhandler Language="C#" class="Upload" %>

/**
 * KindEditor ASP.NET
 *
 * 本ASP.NET程序是演示程序，建议不要直接在实际项目中使用。
 * 如果您确定直接使用本程序，使用之前请仔细确认相关安全设置。
 *
 */

using System;
using System.Collections;
using System.Web;
using System.IO;
using System.Globalization;
using LitJson;
using System.Drawing.Imaging;
using System.Drawing;
using System.Drawing.Drawing2D;

public class Upload : IHttpHandler
{
	private HttpContext context;

	public void ProcessRequest(HttpContext context)
	{
		String aspxUrl = context.Request.Path.Substring(0, context.Request.Path.LastIndexOf("/") + 1);
        string srv = Common.DESEncrypt.Decrypt(context.Request.QueryString["srv"].ToString());
        string path = context.Request.QueryString["path"].ToString();
		//文件保存目录路径
        String savePath = "../../../HNTCWLUploadFile/FileUpload/" + srv + path;

		//文件保存目录URL
        String saveUrl = aspxUrl + "../../../HNTCWLUploadFile/FileUpload/" + srv + path;

		//定义允许上传的文件扩展名
		Hashtable extTable = new Hashtable();
		extTable.Add("image", "gif,jpg,jpeg,png,bmp");
		//extTable.Add("flash", "swf,flv");
		//extTable.Add("media", "swf,flv,mp3,wav,wma,wmv,mid,avi,mpg,asf,rm,rmvb");
		//extTable.Add("file", "doc,docx,xls,xlsx,ppt,htm,html,txt,zip,rar,gz,bz2");

		//最大文件大小
        int maxSize = 6291456;
		this.context = context;

		HttpPostedFile imgFile = context.Request.Files["imgFile"];
		if (imgFile == null)
		{
			showError("请选择文件。");
		}

		String dirPath = context.Server.MapPath(savePath);
		if (!Directory.Exists(dirPath))
		{
            Directory.CreateDirectory(dirPath);
		}

        String dirName = context.Request.QueryString["dir"];
        if (String.IsNullOrEmpty(dirName))
        {
            dirName = "image";
        }
        if (!extTable.ContainsKey(dirName))
        {
            showError("目录名不正确。");
        }

		String fileName = imgFile.FileName;
		String fileExt = Path.GetExtension(fileName).ToLower();

		if (imgFile.InputStream == null || imgFile.InputStream.Length > maxSize)
		{
			showError("上传文件大小超过限制。");
		}

		if (String.IsNullOrEmpty(fileExt) || Array.IndexOf(((String)extTable[dirName]).Split(','), fileExt.Substring(1).ToLower()) == -1)
		{
			showError("上传文件扩展名是不允许的扩展名。\n只允许" + ((String)extTable[dirName]) + "格式。");
		}

		//创建文件夹
        //下面两行是去掉文件夹image<王光森 2015-04-07>
		//dirPath += dirName + "/";
		//saveUrl += dirName + "/";
		if (!Directory.Exists(dirPath)) {
			Directory.CreateDirectory(dirPath);
		}
        //String ymd = DateTime.Now.ToString("yyyyMMdd", DateTimeFormatInfo.InvariantInfo);
        //dirPath += ymd + "/";
        //saveUrl += ymd + "/";
        //if (!Directory.Exists(dirPath)) {
        //    Directory.CreateDirectory(dirPath);
        //}

        //原始图片名字
		String newFileName_big = DateTime.Now.ToString("yyyyMMddHHmmss_ffff_oldPic", DateTimeFormatInfo.InvariantInfo) + fileExt;

        //压缩后的图片名字
        String newFileName_small = DateTime.Now.ToString("yyyyMMddHHmmss_ffff", DateTimeFormatInfo.InvariantInfo) + fileExt;
        
        //原图路径
        String oldPath = dirPath + newFileName_big;
        String newPath = dirPath + newFileName_small;
        //在这里修改了文件的压缩
        imgFile.SaveAs(oldPath);//保存原来的图片

        try
        {
            int width = System.Drawing.Image.FromFile(oldPath, false).Width;
            int height = System.Drawing.Image.FromFile(oldPath, false).Height;
            if (width > 800)
            {
                height = 800* height / width;
                width = 800;
              
            }
            //开始压缩图片
            GetPicThumbnail(oldPath, newPath, height, width, 85);
        }
        catch
        {
            showError("您上传的不是图片");
        }


	    string type = context.Request["type"] ?? "";
	    string host = "";
	    string fileUrl = string.Empty;
	    if (type == "host")
	    {
	        fileUrl = "http://" + context.Request.Url.Authority + "/UploadFile/image/" + newFileName_small;
	    }
	    else
	    {
            fileUrl = saveUrl + newFileName_small;
	    }
	  
	    //返回压缩后的文件的名字
      
      

		Hashtable hash = new Hashtable();
		hash["error"] = 0;
		hash["url"] = fileUrl;
		context.Response.AddHeader("Content-Type", "text/html; charset=UTF-8");
		context.Response.Write(JsonMapper.ToJson(hash));
		context.Response.End();
	}

	private void showError(string message)
	{
		Hashtable hash = new Hashtable();
		hash["error"] = 1;
		hash["message"] = message;
		context.Response.AddHeader("Content-Type", "text/html; charset=UTF-8");
		context.Response.Write(JsonMapper.ToJson(hash));
		context.Response.End();
	}
    #region
    /// <summary>
    /// 无损压缩图片
    /// </summary>
    /// <param name="sFile">原图片</param>
    /// <param name="dFile">压缩后保存位置</param>
    /// <param name="dHeight">高度</param>
    /// <param name="dWidth"></param>
    /// <param name="flag">压缩质量 1-100</param>
    /// <returns></returns>
    public bool GetPicThumbnail(string sFile, string dFile, int dHeight, int dWidth, int flag)
    {
        System.Drawing.Image iSource = System.Drawing.Image.FromFile(sFile);

        ImageFormat tFormat = iSource.RawFormat;

        int sW = 0, sH = 0;

        //按比例缩放

        Size tem_size = new Size(iSource.Width, iSource.Height);



        if (tem_size.Width > dHeight || tem_size.Width > dWidth) //将**改成c#中的或者操作符号
        {

            if ((tem_size.Width * dHeight) > (tem_size.Height * dWidth))
            {

                sW = dWidth;

                sH = (dWidth * tem_size.Height) / tem_size.Width;

            }

            else
            {

                sH = dHeight;

                sW = (tem_size.Width * dHeight) / tem_size.Height;

            }

        }

        else
        {

            sW = tem_size.Width;

            sH = tem_size.Height;

        }

        Bitmap ob = new Bitmap(dWidth, dHeight);
        Graphics g = Graphics.FromImage(ob);
        g.Clear(Color.WhiteSmoke);

        g.CompositingQuality = CompositingQuality.HighQuality;

        g.SmoothingMode = SmoothingMode.HighQuality;

        g.InterpolationMode = InterpolationMode.HighQualityBicubic;

        g.DrawImage(iSource, new Rectangle((dWidth - sW) / 2, (dHeight - sH) / 2, sW, sH), 0, 0, iSource.Width, iSource.Height, GraphicsUnit.Pixel);

        g.Dispose();

        //以下代码为保存图片时，设置压缩质量

        EncoderParameters ep = new EncoderParameters();

        long[] qy = new long[1];

        qy[0] = flag;//设置压缩的比例1-100

        EncoderParameter eParam = new EncoderParameter(System.Drawing.Imaging.Encoder.Quality, qy);

        ep.Param[0] = eParam;

        try
        {

            ImageCodecInfo[] arrayICI = ImageCodecInfo.GetImageEncoders();

            ImageCodecInfo jpegICIinfo = null;

            for (int x = 0; x < arrayICI.Length; x++)
            {

                if (arrayICI[x].FormatDescription.Equals("JPEG"))
                {

                    jpegICIinfo = arrayICI[x];

                    break;

                }

            }

            if (jpegICIinfo != null)
            {

                ob.Save(dFile, jpegICIinfo, ep);//dFile是压缩后的新路径

            }

            else
            {

                ob.Save(dFile, tFormat);

            }

            return true;

        }

        catch
        {

            return false;

        }

        finally
        {

            iSource.Dispose();

            ob.Dispose();

        }



    }
    #endregion


    public bool IsReusable
	{
		get
		{
			return true;
		}
	}
}
