
function parsedata(data, tips, dialogname, contextPath) {
    if (data.status) {
        $("#" + dialogname).dialog("close");
        location.href = location.href;
    } else {
        updateTips(tips, data.error);
    }
}

function updateTips(tips, t) {
    tips.html(t).addClass("ui-state-highlight");
    tips.show();
    setTimeout(function () {
        tips.removeClass("ui-state-highlight", 1500);
    }, 500);
}

function checkLength(tips, o, n, min, max, errorclass) {
    if (o.val().replace(/^\s+|\s+$/g, '').length > max
			|| o.val().replace(/^\s+|\s+$/g, '').length < min) {
        if (errorclass == null) {
            o.addClass("ui-state-error");
        } else {
            o.addClass(errorclass);
            o.focus();
        }
        updateTips(tips, n + "的长度必须在" + min + "-" + max + "之间。");
        return false;
    } else {
        return true;
    }
}

function checkRegexp(tips, o, regexp, n, errorclass) {
    if (!(regexp.test(o.val())) || /[<|>]/.test(o.val())) {
        if (errorclass == null) {
            o.addClass("ui-state-error");
        } else {
            o.addClass(errorclass);
            o.focus();
        }
        updateTips(tips, n);
        return false;
    } else {

        return true;
    }
}

function checkEmail(tips, o, errorclass) {
    return checkRegexp(
			tips,
			o,
			/^((([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+(\.([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+)*)|((\x22)((((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(([\x01-\x08\x0b\x0c\x0e-\x1f\x7f]|\x21|[\x23-\x5b]|[\x5d-\x7e]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(\\([\x01-\x09\x0b\x0c\x0d-\x7f]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))))*(((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(\x22)))@((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?$/i,
			"邮箱格式必须类似于: sample@drwaimai.com", errorclass);
}

$.fn.autoTip = function (G) {
    var D;
    D = {
        dvalue: "用户名/电子邮箱", // 表单默认值
        tip: "tip", // 默认提示信息样式名class
        tipnone: "tipnone" // 在指定的input执行click时替换的样式名class
    };
    $.extend(D, G);
    if ($(this).val() == "") {
        $(this).val(D.dvalue).addClass(D.tip).click(function () {
            if ($(this).val() == D.dvalue) {
                $(this).val("");
                $(this).removeClass(D.tip);
                $(this).addClass(D.tipnone);
            }
        }).blur(function () {
            if ($(this).val() == "") {
                $(this).removeClass(D.tipnone);
                $(this).addClass(D.tip);
                $(this).val(D.dvalue);
            }
        });
    }
    ;
}

jQuery.fn.topLink = function (settings) {
    settings = jQuery.extend({
        min: 1,
        fadeSpeed: 200,
        ieOffset: 50
    }, settings);
    return this.each(function () {
        // listen for scroll
        var el = $(this);
        el.css('display', 'none'); // in case the user forgot
        $(window).scroll(
				function () {
				    // stupid IE hack
				    if (!jQuery.support.hrefNormalized) {
				        el.css({
				            'position': 'absolute',
				            'top': $(window).scrollTop() + $(window).height()
									- settings.ieOffset
				        });
				    }
				    if ($(window).scrollTop() >= settings.min) {
				        el.fadeIn(settings.fadeSpeed);
				    } else {
				        el.fadeOut(settings.fadeSpeed);
				    }
				});
    });
};
