(function($){
	$.fn.lazyload = function(options){
		var settings={
			threshold:0,
			failurelimit:0,
			event:"scroll",
			effect:"show",
			container:window
		};
		if(options){
			$.extend(settings,options);
		}
		var elements=this;
		//新增safari4上offset().top会随着滚动条变化而变化值是原始值+$(window).scrollTop()
		var dynload_img_offset = elements.offset().top;
		var dynload_flag = false;
		if("scroll"==settings.event){
			$(settings.container).bind("scroll",function(event){
				var counter=0;
				var dynload_img_first_offset = $(".pic img").offset().top;
				if(parseInt(dynload_img_first_offset) > parseInt(dynload_img_offset) + 5){//允许5像素误差
					dynload_flag = true;
				}else{
					dynload_flag = false;
				}
				elements.each(function(i,val){
					if($.abovethetop(this,settings)||$.leftofbegin(this,settings)){
						
					}else if(!$.belowthefold(this,settings,dynload_flag)&&!$.rightoffold(this,settings)){
						$(this).trigger("appear");
					}else{
						if(counter++>settings.failurelimit){
							return false;
						}
					}
				});
				var temp=$.grep(elements,function(element){
					return!element.loaded;
				});
				elements=$(temp);
			});
		}
		this.each(function(){
			var self=this;
			$(self).one("appear",function(){
				if(!this.loaded){
					$("<img />").bind("load",function(){
						$(self).hide().attr("src",$(self).attr("original"))[settings.effect](settings.effectspeed);
						self.loaded=true;
					}).attr("src",$(self).attr("original"));
				};
			});
			if("scroll"!=settings.event){
				$(self).bind(settings.event,function(event){
					if(!self.loaded){
						$(self).trigger("appear");
					}
				});
			}
		});
		$(settings.container).trigger(settings.event);
		return this;
	};
	$.belowthefold=function(element,settings,dynload_flag){
		if(dynload_flag){
			offset = $(element).offset().top - $(window).scrollTop();
		}else{
			offset = $(element).offset().top
		}
		if(settings.container===undefined||settings.container===window){
			var fold=$(window).height()+$(window).scrollTop();
		}else{
			var fold=$(settings.container).offset().top+$(settings.container).height();
		}
		return fold<=offset-settings.threshold;
	};
	$.rightoffold=function(element,settings){
		if(settings.container===undefined||settings.container===window){
			var fold=$(window).width()+$(window).scrollLeft();
		}else{
			var fold=$(settings.container).offset().left+$(settings.container).width();
		}
		return fold<=$(element).offset().left-settings.threshold;
	};
	$.abovethetop=function(element,settings){
		if(settings.container===undefined||settings.container===window){
			var fold=$(window).scrollTop();
		}else{
			var fold=$(settings.container).offset().top;
		}
		return fold>=$(element).offset().top+settings.threshold+$(element).height();
	};
	$.leftofbegin=function(element,settings){
		if(settings.container===undefined||settings.container===window){
			var fold=$(window).scrollLeft();
		}else{
			var fold=$(settings.container).offset().left;
		}
		return fold>=$(element).offset().left+settings.threshold+$(element).width();
	};
	$.extend($.expr[':'],{
		"below-the-fold":"$.belowthefold(a, {threshold : 0, container: window})",
		"above-the-fold":"!$.belowthefold(a, {threshold : 0, container: window})",
		"right-of-fold":"$.rightoffold(a, {threshold : 0, container: window})",
		"left-of-fold":"!$.rightoffold(a, {threshold : 0, container: window})"
	});
})(jQuery);