﻿$(document)
    .ajaxStart(onStart)                 // 开始
    .ajaxSend(onSend)                   // 发送请求
    .ajaxSuccess(onSuccess)             // 成功处理
    .ajaxError(onError)                 // 失败处理
    .ajaxComplete(onComplete)           // 完成处理
    .ajaxStop(onStop);                  // 停止处理

var page_layerLoading;                  // 遮罩提示对象

function onStart(event) {
    // 开发模式输出
    if (config.developType === 1) {
        console.log("======================================== Global____01____ajaxStart____begin ========================================");
        console.log(event);
        console.log("======================================== Global____01____ajaxStart____end ========================================");
        console.log("=");
    }

    // 业务处理
    if (config.globalAjaxAction === 1) {
    }
}

function onSend(event, xhr, settings) {
    // 开发模式输出
    if (config.developType === 1) {
        console.log("======================================== Global____02____onSend____begin ========================================");
        console.log(event);
        console.log(xhr);
        console.log(settings);
        console.log("======================================== Global____02____onSend____end ========================================");
        console.log("=");
    }

    // 业务处理
    if (config.globalAjaxAction === 1) {
        // 打开提示
        page_layerLoading = layer.open({
            type: 2
            , content: '信息处理中...'
        });
    }
}

function onSuccess(event, xhr, settings) {
    // 开发模式输出
    if (config.developType === 1) {
        console.log("======================================== Global____03____onSuccess____begin ========================================");
        console.log(event);
        console.log(xhr);
        console.log(settings);
        console.log("======================================== Global____03____onSuccess____end ========================================");
        console.log("=");
    }

    // 业务处理
    if (config.globalAjaxAction === 1) {
        // 切换并关闭提示
        page_layerLoading = layer.open({
            type: 2
            , content: '信息处理完成...'
        });
        setTimeout(function () {
            layer.close(page_layerLoading);
        }, 500);
    }
}

function onError(event, xhr, settings) {
    // 开发模式输出
    if (config.developType === 1) {
        console.log("======================================== Global____04____onSuccess____begin ========================================");
        console.log(event);
        console.log(xhr);
        console.log(settings);
        console.log("======================================== Global____04____onSuccess____end ========================================");
        console.log("=");
    }

    // 业务处理
    if (config.globalAjaxAction === 1) {
        // 切换并关闭提示
        page_layerLoading = layer.open({
            type: 2
            , content: '信息处理异常...'
        });
        setTimeout(function () {
            layer.close(page_layerLoading);
        }, 500);
    }
}

function onComplete(event, xhr, settings) {
    // 开发模式输出
    if (config.developType === 1) {
        console.log("======================================== Global____05____onComplete____begin ========================================");
        console.log(event);
        console.log(xhr);
        console.log(settings);
        console.log("======================================== Global____05____onComplete____end ========================================");
        console.log("=");
    }

    // 业务处理
    if (config.globalAjaxTokenAction === 1) {
        // Token信息校验
        var result = JSON.parse(xhr.responseText);
        if (result.error != null && result.error.code === 10001) {
            $.cookie('token', null, { expires: -1, domain: CookieDomain, path: '/' });
            window.location = '/weixin/activitycooperation/shop/login.html';
        }
    }
}

function onStop(event) {
    // 开发模式输出
    if (config.developType === 1) {
        console.log("======================================== Global____06____onStop____begin ========================================");
        console.log(event);
        console.log("======================================== Global____06____onStop____end ========================================");
        console.log("=");
        console.log("=");
        console.log("=");
        console.log("=");
        console.log("=");
    }

    // 业务处理
    if (config.globalAjaxAction === 1) {

    }
}