﻿// Map
// 参考网址1：https://blog.csdn.net/u010989191/article/details/51326397
// 参考网址2：https://www.cnblogs.com/leoguo08/p/Map1.html
// 参考网址3：http://lbsyun.baidu.com/jsdemo.htm#b0_4


// 动态加载资源
; define(function (require) {
    require("http://api.map.baidu.com/getscript?v=2.0&ak=x6ru0bjiuUU3dGBatw4LWGsy&services=&t=20190102133327");
});

// 百度地图API功能
; gblab_baidumap = {
    func: function () {
        // 参数配置
        this.config = {
            // 位置配置
            lng: 0,                 // 经度
            lat: 0,                 // 纬度
            cityname: '厦门',       // 城市信息

            id: '',                 // 地图展现的html元素编号
            point: null,            // 地图中心点坐标对象
            marker: null,           // 中心点标记对象
            high: 18,               // 摄像头高度

            // 输入的信息
            title: '学校软件',
            message: '学校软件说明信息',
            info: '学校软件地址',
            domain: 'http://www.xuexiaoruanjian.com',
            copyrightinfo: '',

            // 开关设置
            ismark: true,           // 标记
            ismaptype: true,        // 地图类型
            isnav: true,            // 导航
            ismin: true,            // 缩略地图
            isposition: true,       // 定位
            iscopyright: true,      // 版权
            ischangecity: true,     // 切换城市
            issubkeyvalueitem: false,   // 是否包含提交事件
            subkeyvalueitemid:0,    // 
        };

        // 控件定义
        this.controls = {
            map: null,              // 地图对象
        };

        // 事件初始化
        this.init = function () {
            var that = this;

            that.config.copyrightinfo = ('<a href="' + that.config.domain + '" target="_blank" style="font-size: 12px;background: white;padding: 5px;border: 1px solid #efefef;font-weight: bold;">' + that.config.title + '</a>');

            this.controls.map = new BMap.Map(this.config.id);

            // 渲染地图
            that.controls.map.centerAndZoom(new BMap.Point(that.config.lng, that.config.lat), that.config.high);       // 初始化地图,设置中心点坐标和地图级别
            that.controls.map.setCurrentCity(that.config.cityname);             // 设置地图显示的城市 此项是必须设置的

            that.controls.map.enableScrollWheelZoom(true);                      // 开启鼠标滚轮缩放
            that.controls.map.disableDragging();                                // 禁止拖拽
            setTimeout(function () {
                that.controls.map.enableDragging();                             // 两秒后开启拖拽
                //this.controls.map.enableInertialDragging();                   // 两秒后开启惯性拖拽
            }, 2000);

            // 添加标注
            that.mark();

            // 添加地图类型控件
            that.maptype();

            // 添加带有定位的导航控件
            that.nav();

            // 添加缩略地图
            that.min();

            // 添加定位控件
            that.position();

            // 添加版权信息
            that.copyright();

            // 添加城市切换
            that.changecity();

            // 添加自定义控制按钮
            that.button();

            that.addpoint();
        };

        // 业务事件 -添加标注
        this.mark = function () {
            var that = this;
            if (that.config.ismark === true) {
                var point = new BMap.Point(this.config.lng, this.config.lat);
                var marker = new BMap.Marker(point);                                // 创建标注
                this.controls.map.addOverlay(marker);                                             // 将标注添加到地图中
                this.controls.map.centerAndZoom(point, this.config.high);
                var opts = {
                    width: 300,                                                     // 信息窗口宽度
                    height: 150,                                                    // 信息窗口高度
                    title: this.config.title,                                       // 信息窗口标题
                    enableMessage: true,                                            // 设置允许信息窗发送短息
                    message: this.config.message
                }
                var infoWindow = new BMap.InfoWindow(this.config.info, opts);       // 创建信息窗口对象
                marker.addEventListener("click", function () {
                    that.controls.map.openInfoWindow(infoWindow, point);            //开启信息窗口
                });
            }
        };

        // 业务事件 -添加地图类型控件
        this.maptype = function () {
            var that = this;
            if (that.config.ismaptype === true) {
                //添加地图类型控件
                this.controls.map.addControl(new BMap.MapTypeControl({
                    mapTypes: [
                        BMAP_NORMAL_MAP,
                        BMAP_HYBRID_MAP
                    ]
                    , offset: new BMap.Size(10, 40)
                }));
            }
        };

        // 业务事件 -添加带有定位的导航控件
        this.nav = function () {
            var that = this;
            if (that.config.isnav === true) {
                // 添加带有定位的导航控件
                var navigationControl = new BMap.NavigationControl({
                    // 靠左上角位置
                    anchor: BMAP_ANCHOR_TOP_LEFT,
                    // LARGE类型
                    type: BMAP_NAVIGATION_CONTROL_LARGE,
                    // 启用显示定位
                    enableGeolocation: true
                });
                that.controls.map.addControl(navigationControl);
            }
        };

        // 业务事件 -添加缩略地图
        this.min = function () {
            var that = this;
            if (that.config.ismin === true) {
                // 添加缩略地图
                var overView = new BMap.OverviewMapControl();
                var overViewOpen = new BMap.OverviewMapControl({ isOpen: true, anchor: BMAP_ANCHOR_BOTTOM_RIGHT });
                that.controls.map.addControl(overView);                           // 添加默认缩略地图控件
                that.controls.map.addControl(overViewOpen);                       // 右下角，打开
            }
        };

        // 业务事件 -添加定位控件
        this.position = function () {
            var that = this;
            if (that.config.isposition === true) {
                // 添加定位控件
                var opts = { offset: new BMap.Size(10, 60) }        // 设置偏移量，如果控件有位置问题的时候 可以通过这里制定呈现位置
                var geolocationControl = new BMap.GeolocationControl(opts);
                geolocationControl.addEventListener("locationSuccess", function (e) {
                    // 定位成功事件
                    var address = '';
                    address += e.addressComponent.province;
                    address += e.addressComponent.city;
                    address += e.addressComponent.district;
                    address += e.addressComponent.street;
                    address += e.addressComponent.streetNumber;
                    alert("当前定位地址为：" + address);
                });
                geolocationControl.addEventListener("locationError", function (e) {
                    // 定位失败事件
                    console.log(e.message);
                });
                that.controls.map.addControl(geolocationControl);
            }
        };

        // 业务事件 -添加版权信息
        this.copyright = function () {
            var that = this;
            if (that.config.iscopyright === true) {
                // 添加版权信息
                var cr = new BMap.CopyrightControl({ anchor: BMAP_ANCHOR_TOP_RIGHT, offset: new BMap.Size(10, 10) });   //设置版权控件位置
                that.controls.map.addControl(cr);                                 // 添加版权控件
                var bs = that.controls.map.getBounds();                           // 返回地图可视区域
                cr.addCopyright({
                    id: 1, content: that.config.copyrightinfo, bounds: bs
                });                                                                 // Copyright(id,content,bounds)类作为CopyrightControl.addCopyright()方法的参数
            }
        };

        // 业务事件 -添加城市切换
        this.changecity = function () {
            var that = this;
            if (that.config.ischangecity === true) {
                // 添加城市切换
                var size = new BMap.Size(10, 80);
                that.controls.map.addControl(new BMap.CityListControl({
                    anchor: BMAP_ANCHOR_TOP_RIGHT,
                    offset: size,
                    // 切换城市之间事件
                    onChangeBefore: function () {
                        console.log('before');
                    },
                    // 切换城市之后事件
                    onChangeAfter: function () {
                        console.log('after');
                    }
                }));
            }
        };

        // 添加自定义控制按钮
        this.button = function () {
            var that = this;
            var menu = new BMap.ContextMenu();
            var txtMenuItem = [
                {
                    text: '放大',
                    callback: function () { that.controls.map.zoomIn() }
                },
                {
                    text: '缩小',
                    callback: function () { that.controls.map.zoomOut() }
                }
            ];
            for (var i = 0; i < txtMenuItem.length; i++) {
                menu.addItem(new BMap.MenuItem(txtMenuItem[i].text, txtMenuItem[i].callback, 100));
            }
            that.controls.map.addContextMenu(menu);
        };

        // 添加节点
        this.addpoint = function () {
            var that = this;
            if (that.config.issubkeyvalueitem === true) {
                var geoc = new BMap.Geocoder();
                var opts = {
                    width: 300,                                                     // 信息窗口宽度
                    height: 150,                                                    // 信息窗口高度
                    enableMessage: false                                            // 设置允许信息窗发送短息
                }

                that.controls.map.addEventListener("dblclick", function (e) {
                    var marker;
                    var lastPoint = new BMap.Point(118.10, 24.50);
                    marker = new BMap.Marker(lastPoint);

                    that.controls.map.clearOverlays();

                    var pt = e.point;
                    marker = new BMap.Marker(pt);
                    marker.addEventListener("click", function () {
                        var showStr = "经纬度值:<br>" + "经度:" + pt.lng + "<br/>纬度 :" + pt.lat + "<br/>";
                        var infoWindow = new BMap.InfoWindow(showStr, opts);
                        that.controls.map.openInfoWindow(infoWindow, pt);
                    });
                    that.controls.map.addOverlay(marker);
                    geoc.getLocation(pt, function (rs) {
                        var addComp = rs.addressComponents;
                        var showStr = "<a href='#this' style='color:green;font-size:12pt;font-weight:bold;' onclick='Item_Sub_BaiDu(\"" + that.config.subkeyvalueitemid + "\",\"" + pt.lng + "\",\"" + pt.lat + "\")'>提交公司地址</a><br/><br/>"
                        showStr += "经纬度值:<br>" + "经度:" + pt.lng + "<br/>纬度 :" + pt.lat + "<br/>" + addComp.province + addComp.city + addComp.district + addComp.street + addComp.streetNumber;
                        var infoWindow = new BMap.InfoWindow(showStr, opts);
                        that.controls.map.openInfoWindow(infoWindow, pt);
                    });
                });
                $("#" + that.config.id).css("overflow", "hidden");
            }
        };

        this.subkeyvalueitem = function () {
            alert('test');
        }
    }
};
function Item_Sub_BaiDu(id, jingdu, weidu) {
    alertMsg.confirm('确认此处为公司的地址吗？', {
        okCall: function () {
            // 获取分类信息
            $.ajax({
                type: 'Post',
                url: '/manage/keyvalueitem/Action_Edit_UpdateBaiduMap',
                data: 'id=' + id + '&jingdu=' + jingdu + '&weidu=' + weidu,
                success: function (data) {
                    if (data.statusCode == 200) {
                        alertMsg.correct('更新成功!');
                    } else {
                        alertMsg.error('更新失败!');
                    }
                }
            });
        }
    });
}


//  参考网址：https://www.cnblogs.com/zqzjs/p/5293698.html


//  4.移动地图，设置地图最大最小的缩放级别
//  var map = new BMap.Map("allmap", { minZoom: 4, maxZoom: 8 }); // 创建Map实例,设置地图允许的最小/大级别
//  //当然也可以动态设置级别：
//  map.setMaxZoom(10);
//  map.setMinZoom(2);


//5.获得地图当前中心点，返回两点间的距离
//getCenter()
//getDistance(start: Point, end: Point)
//var pointA = new BMap.Point(106.486654, 29.490295);  // 创建点坐标A--大渡口区
//var pointB = new BMap.Point(106.581515, 29.615467);  // 创建点坐标B--江北区
//alert('距离是：' + (map.getDistance(pointA, pointB)).toFixed(2) + ' 米。');  //获取两点距离,保留小数点后两位