﻿
// 页面初始化
$(function () {
    console.log('init');
    // 框架信息初始化
    DWZ.init("/Areas/Manage/dwz.frag.xml", {
        loginUrl: "/Areas/Manage/login_dialog.html"
        , loginTitle: "登录超时，请重新登录。"             // 弹出登录对话框
        //, loginUrl: "/login.aspx"	                        // 跳到登录页面
        , statusCode: { ok: 200, error: 300, timeout: 301 }  //【可选】
        , pageInfo: {
            pageNum: "pageNum"
            , numPerPage: "numPerPage"
            , orderField: "orderField"
            , orderDirection: "orderDirection"
        }, //【可选】
        debug: false,                                       // 调试模式 【true|false】
        callback: function () {
        }
    });

    // 权限菜单加载
    $.ajax({
        type: "GET",
        url: "/Manage/User/GetUserPermit",
        success: function (MidList) {
            console.log(MidList);
            $(".accordion").hide();
            var TagHeadTemplate = '<div class="accordionHeader"><h2><span>Folder</span>$F_Name</h2></div><div class="accordionContent"><ul class="tree treeFolder">';
            var TagDownTemplate = '</ul></div>';

            var ModuleHeadTemplate = '<li><a>$F_Name</a><ul>';
            var ModuleDownTemplate = '</ul></li>';

            var FunctionTemplate = '<li><a href="$F_Url" target="navTab" rel="page_$F_Name" fresh="false">$F_Name</a></li>';

            var Info = '';

            for (var i = 0; i < MidList.length; i++) {
                Info += TagHeadTemplate.replace('$F_Name', MidList[i].name);
                for (var j = 0; j < MidList[i].MidList.length; j++) {
                    Info += ModuleHeadTemplate.replace('$F_Name', MidList[i].MidList[j].name);
                    for (var k = 0; k < MidList[i].MidList[j].MidList.length; k++) {
                        Info += FunctionTemplate.replace('$F_Name', MidList[i].MidList[j].MidList[k].name).replace('$F_Name', MidList[i].MidList[j].MidList[k].name).replace('$F_Url', MidList[i].MidList[j].MidList[k].url);
                    }
                    Info += ModuleDownTemplate;
                }
                Info += TagDownTemplate;
            }

            $(".accordion").html($(".accordion").html() + Info);
            $(".accordion").show()
            initEnv();
            $("#themeList").theme({ themeBase: "themes" }); // themeBase 相对于index页面的主题base路径
        }
    });

    // 头部信息加载
    $.ajax({
        type: "GET",
        url: "/Index/GetIndexHeadInfo",
        data: "num=" + Math.round(Math.random() * 10000),
        success: function (data) {
            try {
                $("#Head_UserInfo").html("欢迎您：" + data[2].toString());
                $("#Head_IpInfo").html("当前IP：" + data[1].toString());
            } catch (e) {
            }
        }
    });

});

// 扩展函数
String.prototype.format = function (args) {
    var result = this;
    if (arguments.length > 0) {
        if (arguments.length == 1 && typeof (args) == "object") {
            for (var key in args) {
                if (args[key] != undefined) {
                    var reg = new RegExp("({" + key + "})", "g");
                    result = result.replace(reg, args[key]);
                }
            }
        }
        else {
            for (var i = 0; i < arguments.length; i++) {
                if (arguments[i] != undefined) {
                    //var reg = new RegExp("({[" + i + "]})", "g");//这个在索引大于9时会有问题，谢谢何以笙箫的指出

                    var reg = new RegExp("({)" + i + "(})", "g");
                    result = result.replace(reg, arguments[i]);
                }
            }
        }
    }
    return result;
}

// 退出
function loginOut() {
    alertMsg.confirm("确认要退出吗？", {
        okCall: function () {
            window.location.href = "/Login.aspx";
        }
    });
}

// 弹出呈现相册
function showImage(source) {
    var sourceItem = source.split("|")
    var templateItem = '{"alt":"{0}","pid":{1},"src":"{2}","thumb":"{2}"}';
    var template = '{"title":"相册预览","id":123,"start":0,"data":[{0}]}';
    var result = "";
    for (var i = 0; i < sourceItem.length; i++) {
        if (sourceItem[i] == '') {
            continue;
        }
        if (i == 0) {
            result += templateItem.format(sourceItem[i], i, sourceItem[i]);
        } else {
            result += ',' + templateItem.format(sourceItem[i], i, sourceItem[i]);
        }
    }
    result = template.format(result);
    layer.photos({
        photos: $.parseJSON(result),
        anim: 5,
        tab: function (pic, layero) {
            console.log(pic) //当前图片的一些信息
        }
    });
}

// 弹出呈现相册
function showNewImage(controlids) {
    // Photoswipe - 相册1
    var images = new bzw315_images.func();
    images.controls.$imgs = $(controlids);
    images.config.bgOpacity = 1;
    images.init();
    console.log(images);
}