﻿function JsonToObj(jsonstr) {
    /// <summary>
    /// jsonstr 转换为 对象
    /// </summary>
    /// <param name="jsonstr" type="String"></param>
    /// <returns></returns>
    return $.parseJSON(jsonstr);
}

function ObjToJson(o) {
    /// <summary>
    /// 对象 转换为 jsonstr
    /// </summary>
    /// <param name="o" type="Object"></param>
    /// <returns></returns>
    if (o == null) return null;
    var r = [];
    if (o != null) {
        if (typeof o == "string")
            return "\"" + o.replace(/([\'\"\\])/g, "\\$1").replace(/(\n)/g, "\\n").replace(/(\r)/g, "\\r").replace(/(\t)/g, "\\t") + "\"";
        if (typeof o == "object") {
            if (!o.sort) {
                for (var i in o)
                    if (typeof o[i] != "function" && i != "yz") {
                        var type = o[i];
                        var aa = "\"" + i + "\":" + ObjToJson(o[i]);
                        r.push(aa);
                    }
                r = "{" + r.join() + "}";
            } else {
                for (var i = 0; i < o.length; i++)
                    if (typeof o[i] != "function") {
                        r.push(ObjToJson(o[i]))
                    }
                r = "[" + r.join() + "]"
            }
            return r;
        }
        if (typeof o == "boolean")
            return "\"" + o.toString() + "\"";
        else
            return o.toString();
    }
}

function QueryString(sName) {
    var sSource = String(window.document.location);
    var sReturn = "";
    var sQUS = "?";
    var sAMP = "&";
    var sEQ = "=";
    var iPos;

    iPos = sSource.indexOf(sQUS);

    var strQuery = sSource.substr(iPos, sSource.length - iPos);
    var strLCQuery = strQuery.toLowerCase();
    var strLCName = sName.toLowerCase();

    iPos = strLCQuery.indexOf(sQUS + strLCName + sEQ);
    if (iPos == -1) {
        iPos = strLCQuery.indexOf(sAMP + strLCName + sEQ);
        if (iPos == -1)
            return "";
    }

    sReturn = strQuery.substr(iPos + sName.length + 2, strQuery.length - (iPos + sName.length + 2));
    var iPosAMP = sReturn.indexOf(sAMP);

    if (iPosAMP == -1)
        return decodeURIComponent(sReturn);
    else {
        sReturn = sReturn.substr(0, iPosAMP);
    }
    return decodeURIComponent(sReturn); //URL传递空格问题
}

Date.prototype.Format = function (formatStr) {
    var str = formatStr;
    var Week = ['日', '一', '二', '三', '四', '五', '六'];

    str = str.replace(/yyyy|YYYY/, this.getFullYear());
    str = str.replace(/yy|YY/, (this.getYear() % 100) > 9 ? (this.getYear() % 100).toString() : '0' + (this.getYear() % 100));

    str = str.replace(/MM/, (this.getMonth() + 1) > 9 ? (this.getMonth() + 1).toString() : '0' + (this.getMonth() + 1));
    str = str.replace(/M/g, this.getMonth() + 1);

    str = str.replace(/w|W/g, Week[this.getDay()]);

    str = str.replace(/dd|DD/, this.getDate() > 9 ? this.getDate().toString() : '0' + this.getDate());
    str = str.replace(/d|D/g, this.getDate());

    str = str.replace(/hh|HH/, this.getHours() > 9 ? this.getHours().toString() : '0' + this.getHours());
    str = str.replace(/h|H/g, this.getHours());
    str = str.replace(/mm/, this.getMinutes() > 9 ? this.getMinutes().toString() : '0' + this.getMinutes());
    str = str.replace(/m/g, this.getMinutes());

    str = str.replace(/ss|SS/, this.getSeconds() > 9 ? this.getSeconds().toString() : '0' + this.getSeconds());
    str = str.replace(/s|S/g, this.getSeconds());

    return str;
}
Date.prototype.FormatDef = function () {
    return this.Format("yyyy-MM-dd");
}