﻿<%@ WebHandler Language="C#" Class="directory_handler" %>
using System;
using System.Web;
using Jayrock.Json;
using System.IO;
using System.Data;
using RecordDataService;

public class directory_handler : IHttpHandler {
    
    public void ProcessRequest (HttpContext context) {
        context.Response.ContentType = "text/plain";
        object root = context.Request["root"] ;

        if (root != null)
            context.Response.Write(getNode(context,root.ToString()));
    }

    public string getNode(HttpContext context,string root)
    {
        JsonArray list = null;
        String type = null;
        if(context.Request["type"]!=null){
            type = context.Request["type"].ToLower().Trim();
        }else{
            return String.Empty;
        }
        
        switch (type)
        {
            case "admin":
                if (root == "source")
                    list = AdminSchoolNodes();
                else
                    list = AdminTeacherNodes(root);
                    break;
            case "school":
                if (root == "source")
                    list = SchoolTeacherNodes(context.Request["school"].ToString());
                break;
            default:
                break;
        }
        

        return list.ToString();
    }
    private JsonArray AdminSchoolNodes()
    {
        JsonArray list = new JsonArray();
        
        School_Service school = new School_Service();
        DataTable data = school.getSchoolNote();
        
        foreach (DataRow row in data.Rows)
        {
            JsonObject item = new JsonObject();
            item.Accumulate("type","shool");
            item.Accumulate("id",row[0].ToString());
            item.Accumulate("text",row[1].ToString());
            item.Accumulate("show", row[2].ToString());
            item.Accumulate("hasChildren", true);
            item.Accumulate("url", String.Format("J1_ShoolTeacher.aspx?id={0}",row[0].ToString()));
            list.Add(item);
        }
        return list;
    }

    public JsonArray AdminTeacherNodes(String root)
    {
        JsonArray list = new JsonArray();

        Teacher_Service teacher = new Teacher_Service();
        
        DataTable data = teacher.getTeacherNodes(root);
        
        foreach (DataRow row in data.Rows)
        {
            JsonObject item = new JsonObject();
            item.Accumulate("type","teacher");
            item.Accumulate("id",row[0].ToString());
            item.Accumulate("text",row[1].ToString());
            item.Accumulate("state", row[2].ToString());
            item.Accumulate("hasChildren", false);
            item.Accumulate("url", String.Format("J1_Performance.aspx?id={0}", row[0].ToString()));
            list.Add(item);
        }
        return list;
    }

    private JsonArray SchoolTeacherNodes(String school)
    {
        JsonArray list = new JsonArray();
        Teacher_Service teacher = new Teacher_Service();
        DataTable data = teacher.getTeacherNodes(school);

        foreach (DataRow row in data.Rows)
        {
            JsonObject item = new JsonObject();
            item.Accumulate("id", row[0].ToString());
            item.Accumulate("text", row[1].ToString());
            item.Accumulate("state", row[2].ToString());
            item.Accumulate("hasChildren", false);
            item.Accumulate("url", String.Format("J1_TeacherPerformance.aspx?id={0}", row[0].ToString()));
            list.Add(item);
        }
        return list;
        
    }

    public bool IsReusable {
        get {
            return false;
        }
    }

}