﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Entity
{
    public class PageList<T>
    {
        public PageList(List<T> recorderList, int pageNum, int pageSize)
        {
            _recorderList = recorderList;
            _pageNum = pageNum;
            _pageSize = pageSize;
        }

        private List<T> _recorderList=null;
        private int _pageNum=1;
        private int _pageSize=10;

        public List<T> RecorderList
        {
            get
            {
                int startIndex = (PageNum - 1) * PageSize;
                int endIndex = startIndex + PageSize;
                List<T> list = new List<T>();
                if (startIndex >= RecorderCount)
                {
                    return list;
                }
                if (endIndex >RecorderCount)
                {
                    endIndex = RecorderCount;
                }
                for (int i = startIndex; i < endIndex; i++)
                {
                    list.Add(_recorderList[i]);
                }
                return list;
            }
        }

        public int PageNum
        {
            get
            {
                if (_pageNum <= 0)
                    _pageNum = 1;
                return _pageNum;
            }
        }

        public int PageSize
        {
            get
            {
                if (_pageSize <= 0)
                    _pageSize = 10;
                return _pageSize;
            }
        }

        public int PageCount
        {
            get
            {
                if (RecorderCount % PageSize == 0)
                    return RecorderCount / PageSize;

                return RecorderCount / PageSize + 1;
            }
        }

        public int RecorderCount
        {
            get 
            {
                if(_recorderList==null)
                    return 0;
                return _recorderList.Count;
            }
        }
    }
}
