﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Collections.Generic;

using Entity;
using BLL;

public partial class Admin_Marking_MarkPaper2 : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        RoleCheck.DenyLogin();
        if (!IsPostBack)
            BindPaperInfo();
    }
    private int paperID
    {
        get
        { return Helper.GetUrlParmValue("paperID"); }
    }

    private int testID
    {
        get
        { return Helper.GetUrlParmValue("testID"); }
    }

    private int recorderID
    {
        get { return Helper.GetUrlParmValue("recorderID"); }
    }

    private void BindPaperInfo()
    {
        PaperByManualSelection paper = new BLLPaperByManuaSelection().GetPaper(testID,paperID,recorderID);
        if (paper != null)
        {
            int totalScoresForTester = 0;

            rptSubjectOfFillBlankList.DataSource = paper.FillBlankList;
            rptSubjectOfFillBlankList.DataBind();
            lblFillBlankListCount.Text = paper.FillBlankList.Count.ToString();
            if (paper.FillBlankList.Count > 0)
            {
                lblFillBlankScores.Text = paper.FillBlankList[0].Scores.ToString();
                lblFillBlankTotalScores.Text = (paper.FillBlankList[0].Scores * paper.FillBlankList.Count).ToString();
                int totalScoresForTesterOfSubject = 0;
                foreach (SubjectOfFillBlank subject in paper.FillBlankList)
                {
                    totalScoresForTester += subject.ScoresForTester;
                    totalScoresForTesterOfSubject += subject.ScoresForTester;
                }
                lblFillBlankTotalScoresForTester.Text = totalScoresForTesterOfSubject.ToString();
            }

            rptSubjectOfJudgeList.DataSource = paper.JudgeList;
            rptSubjectOfJudgeList.DataBind();
            lblJudgeListCount.Text = paper.JudgeList.Count.ToString();
            
            if (paper.JudgeList.Count > 0)
            {
                lblJudgeScores.Text = paper.JudgeList[0].Scores.ToString();
                lblJudgeTotalScores.Text = (paper.JudgeList[0].Scores * paper.JudgeList.Count).ToString();
                int totalScoresForTesterOfSubject = 0;
                foreach (SubjectOfJudge subject in paper.JudgeList)
                {
                    totalScoresForTester += subject.ScoresForTester;
                    totalScoresForTesterOfSubject += subject.ScoresForTester;
                }
                lblJudgeTotalScoresForTester.Text = totalScoresForTesterOfSubject.ToString();
            }

            rptSubjectOfSingleSelectionList.DataSource = paper.SingleSelectionList;
            rptSubjectOfSingleSelectionList.DataBind();
            lblSingleSelectionCount.Text = paper.SingleSelectionList.Count.ToString();

            if (paper.SingleSelectionList.Count > 0)
            {
                lblSingleSelectionScores.Text = paper.SingleSelectionList[0].Scores.ToString();
                lblSingleSelectionTotalScores.Text = (paper.SingleSelectionList[0].Scores * paper.SingleSelectionList.Count).ToString();
                int totalScoresForTesterOfSubject = 0;
                foreach (SubjectOfSingleSelection subject in paper.SingleSelectionList)
                {
                    totalScoresForTester += subject.ScoresForTester;
                    totalScoresForTesterOfSubject += subject.ScoresForTester;
                }
                lblSingleSelectionTotalScoresForTester.Text = totalScoresForTesterOfSubject.ToString();
            }

            rptSubjectOfMultiSelectionList.DataSource = paper.MultiSelectionList;
            rptSubjectOfMultiSelectionList.DataBind();
            lblMultiSelectionCount.Text = paper.MultiSelectionList.Count.ToString();
            if (paper.MultiSelectionList.Count > 0)
            {
                lblMultiSelectionScores.Text = paper.MultiSelectionList[0].Scores.ToString();
                lblMultiSelectionTotalScores.Text = (paper.MultiSelectionList[0].Scores * paper.MultiSelectionList.Count).ToString();
                int totalScoresForTesterOfSubject = 0;
                foreach (SubjectOfMultiSelection subject in paper.MultiSelectionList)
                {
                    totalScoresForTester += subject.ScoresForTester;
                    totalScoresForTesterOfSubject += subject.ScoresForTester;
                }
                lblMultiSelectionTotalScoresForTester.Text = totalScoresForTesterOfSubject.ToString();
            }

            rptSubjectOfSimpleAnswerList.DataSource = paper.SimpleAnswerList;
            rptSubjectOfSimpleAnswerList.DataBind();
            lblSimpleAnswerCount.Text = paper.SimpleAnswerList.Count.ToString();
            if (paper.SimpleAnswerList.Count > 0)
            {
                int totalScores = 0;
                foreach (SubjectOfSimpleAnswer subject in paper.SimpleAnswerList)
                {
                    totalScores += subject.Scores;
                }
                lblSimpleAnswerTotalScores.Text = totalScores.ToString();
                int totalScoresForTesterOfSubject = 0;
                foreach (SubjectOfSimpleAnswer subject in paper.SimpleAnswerList)
                {
                    totalScoresForTester += subject.ScoresForTester;
                    totalScoresForTesterOfSubject += subject.ScoresForTester;
                }
                lblSimpleAnswerTotalScoresForTester.Text = totalScoresForTesterOfSubject.ToString();
            }

            lblTotalScores.Text = (Convert.ToInt32(lblFillBlankTotalScores.Text)
                + Convert.ToInt32(lblJudgeTotalScores.Text)
                + Convert.ToInt32(lblSingleSelectionTotalScores.Text)
                + Convert.ToInt32(lblMultiSelectionTotalScores.Text)
                +Convert.ToInt32(lblSimpleAnswerTotalScores.Text)).ToString();

            txtTotalScoresForTester.Text = totalScoresForTester.ToString();
        }
    }

    protected void btnSave_Click(object sender, EventArgs e)
    {
        TestMark mark = new TestMark();
        mark.TestRecorder.RecorderID = recorderID;
        mark.TotalScore =Convert.ToUInt16(txtTotalScoresForTester.Text);
        mark.Marker = SessionClass.GetLoginUser();
        mark.MarkedTime = DateTime.Now;
        mark.Remark = txtRemark.Text;

        new BLLTestMark().CreateTestMark(mark, list1, list2, list3, list4, list5);
        Response.Redirect("testerList.aspx?testID="+testID);
    }

    #region 得分信息
    private List<SubjectOfFillBlank> list1
    {
        get
        {
            List<SubjectOfFillBlank> list = new List<SubjectOfFillBlank>();
            foreach (RepeaterItem item in rptSubjectOfFillBlankList.Items)
            {
                try
                {
                    HiddenField hid = (HiddenField)item.FindControl("hidFillBlankID");
                    int id = Convert.ToInt32(hid.Value);
                    TextBox txt = (TextBox)item.FindControl("txtFillBlankScoresForTester");
                    int scoresForTester = Convert.ToInt32(txt.Text);

                    SubjectOfFillBlank subject = new SubjectOfFillBlank();
                    subject.Id = id;
                    subject.ScoresForTester=scoresForTester;

                    list.Add(subject);
                }
                catch { }
            }
            return list;
        }
    }

    private List<SubjectOfJudge> list2
    {
        get
        {
            List<SubjectOfJudge> list = new List<SubjectOfJudge>();
            foreach (RepeaterItem item in rptSubjectOfJudgeList.Items)
            {
                try
                {
                    HiddenField hid = (HiddenField)item.FindControl("hidJudgeID");
                    int id = Convert.ToInt32(hid.Value);
                    TextBox txt = (TextBox)item.FindControl("txtJudgeScoresForTester");
                    int scoresForTester = Convert.ToInt32(txt.Text);

                    SubjectOfJudge subject = new SubjectOfJudge();
                    subject.Id = id;
                    subject.ScoresForTester = scoresForTester;

                    list.Add(subject);
                }
                catch { }
            }
            return list;
        }
    }

    private List<SubjectOfSingleSelection> list3
    {
        get
        {
            List<SubjectOfSingleSelection> list = new List<SubjectOfSingleSelection>();
            foreach (RepeaterItem item in rptSubjectOfSingleSelectionList.Items)
            {
                try
                {
                    HiddenField hid = (HiddenField)item.FindControl("hidSingleSelectionID");
                    int id = Convert.ToInt32(hid.Value);
                    TextBox txt = (TextBox)item.FindControl("txtSingleSelectionScoresForTester");
                    int scoresForTester = Convert.ToInt32(txt.Text);

                    SubjectOfSingleSelection subject = new SubjectOfSingleSelection();
                    subject.Id = id;
                    subject.ScoresForTester = scoresForTester;

                    list.Add(subject);
                }
                catch { }
            }
            return list;
        }
    }

    private List<SubjectOfMultiSelection> list4
    {
        get
        {
            List<SubjectOfMultiSelection> list = new List<SubjectOfMultiSelection>();
            foreach (RepeaterItem item in rptSubjectOfMultiSelectionList.Items)
            {
                try
                {
                    HiddenField hid = (HiddenField)item.FindControl("hidMultiSelectionID");
                    int id = Convert.ToInt32(hid.Value);
                    TextBox txt = (TextBox)item.FindControl("txtMultiSelectionScoresForTester");
                    int scoresForTester = Convert.ToInt32(txt.Text);

                    SubjectOfMultiSelection subject = new SubjectOfMultiSelection();
                    subject.Id = id;
                    subject.ScoresForTester = scoresForTester;

                    list.Add(subject);
                }
                catch { }
            }
            return list;
        }
    }

    private List<SubjectOfSimpleAnswer> list5
    {
        get
        {
            List<SubjectOfSimpleAnswer> list = new List<SubjectOfSimpleAnswer>();
            foreach (RepeaterItem item in rptSubjectOfSimpleAnswerList.Items)
            {
                try
                {
                    HiddenField hid = (HiddenField)item.FindControl("hidSimpleAnswerID");
                    int id = Convert.ToInt32(hid.Value);
                    TextBox txt = (TextBox)item.FindControl("txtSimpleAnswerScoresForTester");
                    int scoresForTester = Convert.ToInt32(txt.Text);

                    SubjectOfSimpleAnswer subject = new SubjectOfSimpleAnswer();
                    subject.Id = id;
                    subject.ScoresForTester = scoresForTester;

                    list.Add(subject);
                }
                catch { }
            }
            return list;
        }
    }
    #endregion
}
