﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;

using Entity;
using BLL;
using Tool;

public partial class Admin_Test_TesterList : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        RoleCheck.DenyLogin();
        if (!IsPostBack)
        {
            int pageNum = 1;
            if (Request.QueryString["pageNum"] != null)
                pageNum = Convert.ToInt32(Request.QueryString["pageNum"]);
            BindTestList(Helper.GetUrlParmValue("testID"), pageNum);
        }
    }

    private const int PAGE_SIZE = 20;
    private void BindTestList(int testID, int pageNum)
    {
        PageList<TestRecorder> list = new BLLTestRecorder().GetTestRecorderListByTestID(testID,pageNum, PAGE_SIZE);
        Repeater1.DataSource = list.RecorderList;
        Repeater1.DataBind();
        lblPageUrl.Text = StringHelper.MakePageUrl("?testID="+testID+"&pageNum=", pageNum, list.PageCount, list.RecorderCount);
    }
}
