﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using BLL;
using Entity;

public partial class Admin_Paper_AddPaper : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        RoleCheck.DenyLogin();
        if (!IsPostBack)
        {
            txtPaperName.Focus();
            
        }
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (drlDeptList.SelectedIndex == 0)
        {
            lblMsg.Text = "请选择部门！";
            return;
        }
        Paper paper = new Paper();
        paper.PaperName = txtPaperName.Text;
        Department dept = new Department();
        dept.DeptID = Convert.ToInt16(drlDeptList.SelectedValue);
        dept.DeptName = drlDeptList.SelectedItem.Text;
        paper.PaperType = dept;
        paper.Content = ftbPaperContent.Text;
        paper.Answer = ftbPaperAnswer.Text;
        paper.Creator =SessionClass.GetLoginUser();

        new BLLPaper().CreatePaper(paper);

        Server.Transfer("paperList.aspx");
    }

    protected void lbtnPreviewPaper_Click(object sender, EventArgs e)
    {
        SessionClass.SetPaperTilte(txtPaperName.Text);
        SessionClass.SetPaperContent(ftbPaperContent.Text);

        Tool.JscriptHelper.OpenNewPage("PreviewPaper.aspx","预览试卷");

    }
}
