﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Collections.Generic;

using Entity;
using BLL;

public partial class Admin_Paper_AddPaperByManualSelection : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        RoleCheck.DenyLogin();
    }

    protected void btnSave_Click(object sender, EventArgs e)
    {
        PaperByManualSelection paper = new PaperByManualSelection();
        paper.PaperName = txtPaperName.Text;
        paper.PaperType.DeptID = Convert.ToInt16(drlDeptList.SelectedValue);
        paper.PaperType.DeptName = drlDeptList.SelectedItem.Text;
        paper.Creator.Name = SessionClass.GetLoginUser().Name;
        paper.CreatedTime = DateTime.Now;
        paper.FillBlankList = SessionClass.GetFillBlankList();
        paper.JudgeList = SessionClass.GetJudgeList();
        paper.SingleSelectionList = SessionClass.GetSingleSelection();
        paper.MultiSelectionList = SessionClass.GetMultiSelection();
        paper.SimpleAnswerList = SessionClass.GetSimpleAnswer();

        new BLLPaperByManuaSelection().CreatePaper(paper);

        SessionClass.SetFillBlankList(null);
        SessionClass.SetJudgeList(null);
        SessionClass.SetSingleSelection(null);
        SessionClass.SetMultiSelection(null);
        SessionClass.SetSimpleAnswer(null);

        Response.Redirect("PaperByManualSelectionList.aspx");
    }

    protected void ObjectDataSource1_Selected(object sender, ObjectDataSourceStatusEventArgs e)
    {
        List<SubjectOfFillBlank> list = (List<SubjectOfFillBlank>)e.ReturnValue;
        if (list == null || list.Count == 0)
        {
            Label1.Visible = true;
        }
        else
        {
            Label1.Visible = false;
            lblFillBlankListCount.Text = list.Count.ToString();
        }
    }

    protected void ObjectDataSource2_Selected(object sender, ObjectDataSourceStatusEventArgs e)
    {
        List<SubjectOfJudge> list = (List<SubjectOfJudge>)e.ReturnValue;
        if (list == null || list.Count == 0)
        {
            Label2.Visible = true;
        }
        else
        {
            Label2.Visible = false;
            lblJudgeListCount .Text = list.Count.ToString();
        }
    }

    protected void ObjectDataSource3_Selected(object sender, ObjectDataSourceStatusEventArgs e)
    {
        List<SubjectOfSingleSelection> list = (List<SubjectOfSingleSelection>)e.ReturnValue;
        if (list == null || list.Count == 0)
        {
            Label3.Visible = true;
        }
        else
        {
            Label3.Visible = false;
            lblSingleSelectionCount.Text = list.Count.ToString();
        }
    }

    protected void ObjectDataSource4_Selected(object sender, ObjectDataSourceStatusEventArgs e)
    {
        List<SubjectOfMultiSelection> list = (List<SubjectOfMultiSelection>)e.ReturnValue;
        if (list == null || list.Count == 0)
        {
            Label4.Visible = true;
        }
        else
        {
            Label4.Visible = false;
            lblMultiSelectionCount.Text = list.Count.ToString();
        }
    }

    protected void ObjectDataSource5_Selected(object sender, ObjectDataSourceStatusEventArgs e)
    {
        List<SubjectOfSimpleAnswer> list = (List<SubjectOfSimpleAnswer>)e.ReturnValue;
        if (list == null || list.Count == 0)
        {
            Label5.Visible = true;
        }
        else
        {
            Label5.Visible = false;
            lblSimpleAnswerCount.Text = list.Count.ToString();
        }
    }
}
