﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;

using Entity;
using BLL;

public partial class Admin_Paper_DelPaper : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        RoleCheck.DenyLogin();
        switch (paperType)
        {
            case PaperType.ByInput:
                try
                {
                    new BLLPaper().DeletePaper(paperID);
                    Response.Redirect("paperList.aspx");
                }
                catch
                {
                    Response.Write("删除失败，很可能是存在使用该试卷的考试，请删除对应的考试再试！");
                }
                break;
            case PaperType.BySelection:
                try
                {
                    new BLLPaperByManuaSelection().DeletePaper(paperID);
                    Response.Redirect("PaperByManualSelectionList.aspx");
                }
                catch
                {
                    Response.Write("删除失败，很可能是存在使用该试卷的考试，请删除对应的考试再试！");
                }
                break;
            case PaperType.ByRandom:
                try
                {
                    new BLLPaperByRandomSelection().DeletePaper(paperID);
                    Response.Redirect("PaperByRandomSelectionList.aspx");
                }
                catch
                {
                    Response.Write("删除失败，很可能是存在使用该试卷的考试，请删除对应的考试再试！");
                }
                break;
            default:
                break;
        }
    }

    private int paperID
    {
        get { return Helper.GetUrlParmValue("paperID"); }
    }

    private PaperType paperType
    {
        get { return (PaperType)Helper.GetUrlParmValue("paperType"); }
    }

}
